
struct VS_INPUT_Shadow
{
	float3 Position : POSITION;
	float3 Normal : NORMAL;
	float4 Diffuse : COLOR;
	float2 UV : TEXCOORD0;
	float4 BoneBlendData[MAX_BONE_BIND_COUNT / 2] : TEXCOORD1;
};

struct VS_OUTPUT_Shadow
{
	float4 Position : POSITION;
	float2 UV : TEXCOORD0;
	float4 ViewPos : TEXCOORD1;
	float4 Diffuse : TEXCOORD2;
};



VS_OUTPUT_Shadow VS_Shadow(VS_INPUT_Shadow In)
{
	VS_OUTPUT_Shadow Out;
	float3 pos;
	if (g_processSkinning)
	{
		
		pos = Skinning(float4(In.Position, 1), In.BoneBlendData);
	}
	else
	{
		pos = In.Position;
	}
	
	float2 uv = In.UV + g_textureAnimationUVOffset;
	pos.xyz = FluidAnimate(pos.xyz, g_fluidAnimationParams.x, g_fluidAnimationParams.y, g_fluidAnimationParams.z, g_fluidAnimationParams.w);
	Out.Position = mul(float4(pos, 1.0f), g_wvpMatrix);
	Out.Position = FixDx9HalfPixelOffset(Out.Position);
	
	Out.UV = uv;
	Out.ViewPos = Out.Position;
	Out.Diffuse = In.Diffuse;
	
	if (g_modelAlphaReplacing >= 0.0f)
	{
		Out.Diffuse.a = g_modelAlphaReplacing;
	}
	
	return Out;
}



float CalcDepth(float4 viewPos, float2 uv)
{
	float depth = viewPos.z/ (viewPos.w);
	return depth;
}


float4 PS_Shadow(VS_OUTPUT_Shadow In) : COLOR
{
	float4 modelColor;
	if (g_haveModelTex)
	{
		modelColor = tex2D(g_texSampler, In.UV) * In.Diffuse;
	}
	else
	{
		modelColor = In.Diffuse;
	}
	
	if (modelColor.a < 0.5f)
	{
		discard;
	}
	
	float4 color = 1.0f;
	color = CalcDepth(In.ViewPos, In.UV);
	
	return color;	
}

technique Shadow
{
	pass p0 
	{
		ZEnable = true;
		ZWriteEnable = true;
		AlphaBlendEnable = false;
		AlphaTestEnable = false;
		
		VertexShader = compile vs_3_0 VS_Shadow();
		PixelShader = compile ps_3_0 PS_Shadow();
	}
}
