void VS_GBuffer(
	in float3 iPosition : POSITION,
	in float3 iNormal   : NORMAL,
	in float4 iDiffuse : COLOR,
	in float2 iUV : TEXCOORD0,
	out float4 oDiffuse : COLOR,
	out float4 oWorldPos : TEXCOORD0,
	out float3 oNormal : TEXCOORD1,
	out float2 oUV :  TEXCOORD2,
#if ENABLE_LINEAR_ZBUFFER	
	out float oLogZ : TEXCOORD3,
#endif
	out float4 oPosition : POSITION
)
{
	float4 pos, normal;
	pos = float4(iPosition ,1);
	normal = float4(iNormal, 0);
	float depth = mul(pos, g_wvMatrix).z;	
	oWorldPos = float4(mul(pos, g_wMatrix).xyz, depth) ;
	oDiffuse = iDiffuse;
	oUV = iUV;
	oNormal = mul((float3)normal, (float3x3) g_wMatrix);
	oPosition = mul(pos, g_wvpMatrix);
	#if ENABLE_LINEAR_ZBUFFER
	oLogZ = 1.0f + oPosition.w;
	#endif
}

void PS_GBuffer(
	in float4 iDiffuse : COLOR,
	in float4 iWorldPos : TEXCOORD0,
	in float3 iNormal : TEXCOORD1,
	in float2 iUV :  TEXCOORD2,
#if ENABLE_LINEAR_ZBUFFER	
	in float iLogZ : TEXCOORD3,
#endif
#if ENABLE_LINEAR_ZBUFFER	
	out float oDepth : DEPTH,
#endif
	out float4 oWorldPos : COLOR0,
	out float4 oNormal : COLOR1,
	out float4 oDiffuse : COLOR2
)
{
	oWorldPos = iWorldPos;
	oNormal = float4(normalize(iNormal), 1.0f);
	float4 texColor = tex2D(g_texSampler, iUV);
	float4 modelColor = iDiffuse * texColor;
	#if DISABLE_MODELCOLOR
	modelColor = float4(1,1,1,1);
	#endif
	#if ENABLE_HOLLOW_EFFECT
	{
		if (texColor.a < 0.3)
		{
			discard;
		}
	}
	#endif
	oDiffuse = modelColor;
	oDiffuse.a = 1.0f;
	
	#if ENABLE_LINEAR_ZBUFFER
	const float Fcoef = 2.0 / log2(g_farClip + 1.0);
	float linearDepth = log2(iLogZ) * (0.5f * Fcoef);
	oDepth = linearDepth;
	#endif
}

technique GBuffer
{
	pass p0 
	{
		AlphaTestEnable = false;
		AlphaBlendEnable = false;
		ZEnable = true;
		ZWriteEnable = true;
		VertexShader = compile vs_3_0 VS_GBuffer();
		PixelShader = compile ps_3_0 PS_GBuffer();
	}
}