#define ENABLE_LINEAR_ZBUFFER 0

struct VS_INPUT
{
	float3 Position : POSITION;
	float4 Diffuse : COLOR;
};

struct VS_OUTPUT
{
	float4 Position : POSITION;
	float4 Diffuse : COLOR;
#if ENABLE_LINEAR_ZBUFFER	
	float LogZ : TEXCOORD1;
#endif
};

struct PS_OUTPUT_Debug
{
	float4 Color : Color0;
#if ENABLE_LINEAR_ZBUFFER
	float Depth : DEPTH;
#endif
};


uniform column_major float4x4 w_matrix;
uniform column_major float4x4 v_matrix;
uniform column_major float4x4 p_matrix;
uniform float g_farClip;

//
// Vertex Shader
//
VS_OUTPUT VS(VS_INPUT In)
{
	VS_OUTPUT Out;
	float4x4 wv_matrix = mul(w_matrix , v_matrix);
	float4x4 wvp_matrix = mul(wv_matrix,  p_matrix);
	Out.Position = mul( float4(In.Position, 1.0f), wvp_matrix);
	Out.Diffuse = In.Diffuse;
#if ENABLE_LINEAR_ZBUFFER
	Out.LogZ = 1.0f + Out.Position.w;
#endif
	return Out;
}


PS_OUTPUT_Debug PS(VS_OUTPUT In)
{	
	PS_OUTPUT_Debug output;
	output.Color = In.Diffuse;
#if ENABLE_LINEAR_ZBUFFER
	const float Fcoef = 2.0 / log2(g_farClip + 1.0);
	float linearDepth = log2(In.LogZ) * (0.5f * Fcoef);
	output.Depth = linearDepth;
#endif

	return output;
}


technique Debug
{

	
	// with depth
	pass p0
	{
		AlphaBlendEnable = true;
		ColorWriteEnable = 0x0000000F; // rgba
		CullMode = 1; //D3DCULL_NONE
		ZWriteEnable = true;
		StencilEnable = false;
		ZEnable = true;
	
		ZFunc = 4; // D3DCMP_LESSEQUAL
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
	}
	
	// no depth
	pass p1
	{
		AlphaBlendEnable = true;
		ColorWriteEnable = 0x0000000F; // rgba
		CullMode = 1; //D3DCULL_NONE
		ZWriteEnable = true;
		StencilEnable = false;
		ZEnable = true;
		
		ZFunc = 8; // D3DCMP_ALWAYS
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
	}
	
	// with depth, no zwrite
	pass p2
	{
		AlphaBlendEnable = true;
		ColorWriteEnable = 0x0000000F; // rgba
		CullMode = 1; //D3DCULL_NONE
		ZWriteEnable = false;
		StencilEnable = false;
		ZEnable = true;
	
		ZFunc = 4; // D3DCMP_LESSEQUAL
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
	}
	
	// no depth, no zwrite
	pass p3
	{
		AlphaBlendEnable = true;
		ColorWriteEnable = 0x0000000F; // rgba
		CullMode = 1; //D3DCULL_NONE
		ZWriteEnable = false;
		StencilEnable = false;
		ZEnable = true;
		
		ZFunc = 8; // D3DCMP_ALWAYS
		VertexShader = compile vs_3_0 VS();
		PixelShader = compile ps_3_0 PS();
	}
	
}