
struct SkinningResult
{
	float4 pos;
	float4 normal;
};

SkinningResult SkinningWithNormal(float4 pos, float4 normal, in float4 boneBindInfo[MAX_BONE_BIND_COUNT / 2])
{
	SkinningResult result;
	result.pos = float4(0, 0,0, 0);
	result.normal = float4(0, 0,0, 0);
	
	float2 blendData[MAX_BONE_BIND_COUNT];
	int acc = 0;
	for(int i = 0; i < MAX_BONE_BIND_COUNT / 2; i++)
	{
		blendData[acc + 0] = boneBindInfo[i].xy;
		blendData[acc + 1] = boneBindInfo[i].zw;
		
		acc += 2;
	}
	
	for(int i = 0; i < MAX_BONE_BIND_COUNT; i++)
	{
		int boneIndex = blendData[i].x;
		float boneWeight = blendData[i].y;
		float4 tempPos = (mul(pos, g_boneTransforms[boneIndex]));
		tempPos /= tempPos.w;
		result.pos += tempPos * boneWeight;
		
		float4 tempNormal = (mul(normal, g_boneTransforms[boneIndex]));
		result.normal += tempNormal * boneWeight;
	}

	result.pos.w = 1.0f;
	result.normal.w = 0.0f;
	return result;
}

float3 Skinning(float4 pos, float4 boneBindInfo[MAX_BONE_BIND_COUNT / 2])
{
	float4 result = 0;
	
	float2 blendData[MAX_BONE_BIND_COUNT];	
	int acc = 0;
	for(int i = 0; i < MAX_BONE_BIND_COUNT / 2; i++)
	{
		blendData[acc + 0] = boneBindInfo[i].xy;
		blendData[acc + 1] = boneBindInfo[i].zw;
		
		acc += 2;
	}
	
	for(int i = 0; i < MAX_BONE_BIND_COUNT; i++)
	{
		int boneIndex = blendData[i].x;
		float boneWeight = blendData[i].y;
		float4 tempPos = mul(pos, g_boneTransforms[boneIndex]);
		tempPos /= tempPos.w;
		result += tempPos * boneWeight;
	}
	result.w = 1.0f;
	return result;
}