#define MAX_BONE_BIND_COUNT 6
#define MAX_BONE_COUNT 30

#define ENABLE_LINEAR_ZBUFFER 0

static const float GameUnitsPerMeter = 21.37;

uniform row_major float4x4 g_wvpMatrix;
uniform row_major float4x4 g_wMatrix;
uniform row_major float4x4 g_wvMatrix;
sampler2D g_texSampler : register (s0);
uniform bool g_haveModelTex;
uniform bool g_processSkinning;
uniform row_major float4x4 g_boneTransforms[MAX_BONE_COUNT];
uniform float2 g_renderTargetSize;
uniform bool g_shadowsEnabled;
uniform float g_farClip;
uniform float2 g_textureAnimationUVOffset;
uniform float4 g_fluidAnimationParams;
uniform float g_modelAlphaReplacing;
uniform float g_hollowThreshold;
uniform float4x4 g_texSpaceMatrix;

float4 FixDx9HalfPixelOffset(float4 wvpPosition)
{
	float4 result = wvpPosition;
	result.xy += (1.0f / g_renderTargetSize * wvpPosition.w);
	return result;
}

float3 FluidAnimate(float3 pos, int deformRef, float deformTime, float deformRange, float deformSize)
{
	float ref = 0;
	if (deformRef <= 0 || deformRef >= 8)
	{
		return pos;
	}
	else if (deformRef == 1)
	{
		ref = pos.x;
	}
	else if (deformRef == 2)
	{
		ref = pos.y;
	}
	else if (deformRef == 3)
	{
		ref = pos.x + pos.y;
	}
	else if (deformRef == 4)
	{
		ref = pos.z;
	}
	else if (deformRef == 5)
	{
		ref = pos.z + pos.x;
	}
	else if (deformRef == 6)
	{
		ref = pos.z + pos.y;
	}
	else if (deformRef == 7)
	{
		ref = pos.z + pos.y + pos.x;
	}
	
	float offset = sin(ref * (1.0f / (deformRange * 6.2831855f)) + deformTime * 6.2831855f) * deformSize;
	return pos + offset;
}

#include "Skinning.fx"
#include "Shadow.fx"
#include "MainLighting.fx"
#include "BlendGodRays.fx"
#include "FixedPipelineEx.fx"
#include "GBuffer.fx"
#include "Deferred.fx"
