struct VS_INPUT_FixedPipelineEx
{
	float3 Position : POSITION;
	float4 Diffuse : COLOR;
	float2 UV : TEXCOORD0;
	float4 BoneBlendData[MAX_BONE_BIND_COUNT / 2] : TEXCOORD1;
};

struct VS_OUTPUT_FixedPipelineEx
{
	float4 Position : POSITION;
	float4 Diffuse : COLOR;
	float2 UV : TEXCOORD0;
#if ENABLE_LINEAR_ZBUFFER	
	float LogZ : TEXCOORD1;
#endif
};

struct PS_OUTPUT_FixedPipelineEx
{
	float4 Color : Color0;
#if ENABLE_LINEAR_ZBUFFER
	float Depth : DEPTH;
#endif
};

VS_OUTPUT_FixedPipelineEx VS_FixedPipelineEx(VS_INPUT_FixedPipelineEx In)
{
	VS_OUTPUT_FixedPipelineEx Out;
	float3 pos = 0;
	if (g_processSkinning)
	{
		pos = Skinning(float4(In.Position, 1.0f), In.BoneBlendData);
	}
	else
	{
		pos = In.Position;
	}
	
	float2 uv = In.UV + g_textureAnimationUVOffset;
	pos.xyz = FluidAnimate(pos.xyz, g_fluidAnimationParams.x, g_fluidAnimationParams.y, g_fluidAnimationParams.z, g_fluidAnimationParams.w);
	
	Out.Position = mul( float4(pos, 1.0f), g_wvpMatrix);		
	Out.Diffuse = In.Diffuse;
	if (g_modelAlphaReplacing >= 0.0f)
	{
		Out.Diffuse.a = g_modelAlphaReplacing;
	}
	
	
	Out.UV = uv;
	
#if ENABLE_LINEAR_ZBUFFER
	Out.LogZ = 1.0f + Out.Position.w;
#endif
	return Out;
}

PS_OUTPUT_FixedPipelineEx PS_FixedPipelineEx(VS_OUTPUT_FixedPipelineEx In)
{
	PS_OUTPUT_FixedPipelineEx output;
#if ENABLE_LINEAR_ZBUFFER
	const float Fcoef = 2.0 / log2(g_farClip + 1.0);
	float linearDepth = log2(In.LogZ) * (0.5f * Fcoef);
	output.Depth = linearDepth;
#endif
	float4 color = 0;
	if (g_haveModelTex)
	{
		color = tex2D(g_texSampler, In.UV) * In.Diffuse;
	}
	else
	{
		color = In.Diffuse;
	}
	output.Color = color;
	return output;
}

technique FixedPipelineEx
{
	pass p0 
	{
		VertexShader = compile vs_3_0 VS_FixedPipelineEx();
		PixelShader = compile ps_3_0 PS_FixedPipelineEx();
	}
}