/*
导入_流星skc模型 by漠之北

0.6
21-12-22
1，删除：操作界面
2，修正：权重数大于4时无法导入的错误
3，增加：同目录下缺少bnc文件时手动指定bnc文件
4，增加：同目录下缺少贴图文件时手动指定贴图文件

0.7
22-05-31
增加字符串以制表符分割
去除导入清除max全部模型功能

0.8
22-07-03
修复max默认材质非标准材质时无法导入
增加材质属性导入
*/
global texPath = "" --贴图路径
struct LXMAT
(
    Id,     tex,    col,    amb,    dif,    spec,   emis,   opac,   opt,    twoside
 --   Texture   nm011b01.jpg
 --   ColorKey  0 0 0 0
 --   Ambient   1.000 1.000 1.000
 --   Diffuse   1.000 1.000 1.000
 --   Specular  1.000 1.000 1.000
 --   Emissive  0.000 0.000 0.000
 --   Opacity   1.000
 --   Option    NONE
 --   TwoSide   FALSE
)	-- end struct LXMAT

struct LXBONE
(
	 	vpos,	vrot,	boneName,		boneId,	parentName,	parentId,		child,	type,

		-- 读入 骨骼块定义格式	,每个块定义如下
		/*
		bone b
		{
			parent d_base
			pivot  0.000 -0.091 21.645
			quaternion -0.70711 0.00000 0.00000 0.70711
			children 1
		}*/
	fn	get_bone	in_fileBnc=
	(				
			for m =1 to 7 do
			(
				line=readline  in_fileBnc		 	-- 读入一行
				subline = filterString  line " 	"		-- 用空格分解为文本数组
					
				case subline[1] of 
				(
					"bone"	:		(	boneName = 	subline[2];	type = 1	)	--1代表bone
					"Dummey"	:	(	boneName = 	subline[2];	type = 2	)	--2代表dummey

					"{"		:	continue
					"parent"	:	parentName = subline[2]
					"pivot"	:	vpos = 	 [ ( subline[2] as float),	(subline[3] as float), (subline[4] as float) ]		-- 取得 骨骼坐标
					"quaternion"	:	vrot =  quat ( subline[3] as float *1.0) 	(subline[4] as float *1)  (subline[5] as float *1)  (subline[2] as float *1) 	
					"children"	:	child = subline[2] as integer
					"}"		:	exit		--	必须用exit,不管上面是否满6行,只要见到 "}" 即结束
				)--end case
				
			)--end for
	)-- end fn get_bone

)--end struct LXBONE

struct LXOBJ	
(

	Id,  verts = #(),	faces = #(),	face_mat =#(),	uvs =#(),	bone_ids =#(),      bone_v_count =#(),	weight_array =#(),	
    groups = #(), mats = #(),  num_mat,   num_vert,  num_face,  skin_name,

--========================================================================================
--                                      取子模型名称
--========================================================================================
    fn  getSkinName in_file=
	(
		while not eof in_file do 	                -- read until reach end of file
		(
			line=   readline  in_file 	            -- 读入一行
			subline = filterString  line " 	"		-- 用空格分解为文本数组
			if subline[1] == "#" do continue 	    -- 跳过注释行
			
			if   subline[1] == "Static" and subline[2] == "Skin"  then 
				(  
					skin_name = subline[3]             --  取得skin名字
			print 	("已取得名称 =" + skin_name)
					exit
				)
			else 
				continue
		)
    ),
--========================================================================================
--                                      取材质
--========================================================================================
    fn  getSkinMats in_file=
	(
		while not eof in_file do 	                -- read until reach end of file
		(
			line=   readline  in_file 	            -- 读入一行
			subline = filterString  line " 	"		-- 用空格分解为文本数组
			if subline[1] == "#" do continue 	    -- 跳过注释行
				
			if  ( subline[1] == "Materials:") then 
					(  
						num_mat = subline[2]as integer             --  取得skin名字
						print 	("已取得材质数量 =" + num_mat as string)
					exit
					)
			else 
				continue
		)
		
		--==================取 每个材质========= ============
		for i = 1 to num_mat do
		(
		for m= 1 to 10 do
				(
			line=readline  in_file 	 
				subline = filterString  line " 	"	
				
					case  subline[1] of 
					(
						"Material"  :   mats[i] =  ( LXMAT     Id:i  )    --创建一个材质
						"Texture"   :   mats[i].tex =   subline[2]      --取纹理名
						"ColorKey"  :   mats[i].col =   #(subline[2] as integer , subline[3] as integer , subline[4] as integer ,  subline[5] as integer )   -- ColorKey  0 0 0 0
						"Ambient"  :   mats[i].amb =   #(subline[2] as float , subline[3] as float , subline[4] as float )  
						"Diffuse"  :   mats[i].dif =   #(subline[2] as float , subline[3] as float , subline[4] as float )   
						"Specular"  :   mats[i].spec =   #(subline[2] as float , subline[3] as float , subline[4] as float )   
						"Emissive"  :   mats[i].emis =   #(subline[2] as float , subline[3] as float , subline[4] as float )   
						"Opacity"  :   mats[i].opac =   subline[2]as float
						"Option"  :   mats[i].opt =     subline[2]      -- NONE
						"TwoSide"  :   mats[i].twoside =     subline[2]      -- FALSE
					)	 --end case
				
		)--end for
		)
     ) , 
--========================================================================================
--                                      取顶点
--========================================================================================
    fn  getSkinVerts in_file=(
		while not eof in_file do 	                -- read until reach end of file
		(
			line=   readline  in_file 	            -- 读入一行
			subline = filterString  line " 	"		-- 用空格分解为文本数组
			if subline[1] == "#" do continue 	    -- 跳过注释行
				
			if  ( subline[1] == "Vertices:") then 
					(  
						num_vert = subline[2]as integer             --  取得顶点数
						format " 取得顶点数=     %   \n"     num_vert
						exit
					)
			else 
				continue
		)
		
		--==================取 每个顶点========= ============
		for v = 1 to num_vert do
		(
			line=readline  in_file 	 
			subline = filterString  line " 	"	
			
			---------------     读入 顶点格式	每个顶点如下
			---------------    v   4.009  -0.445  29.497 vt 0.794 0.765 Bones 3 11 0.51823 15 0.31075 14 0.17102
			
			append verts 	[ (subline[2]as float) ,(subline[3]as float), (subline[4]as float)	]	--读入顶点 坐标
			append uvs 		[ (subline[6]as float) ,(subline[7]as float), 	0,0	]		--	uv坐标是  Point3 类型,				--读入纹理 坐标

			append bone_v_count 	(subline[9]as integer)							--读入本顶点受影响骨骼数量

			tm_ids = #()
			tm_array = #()
			for bv = 1 to bone_v_count[v] do
			(
				tm_bv = (bv-1)*2
				append tm_ids ((subline[10+tm_bv]as integer)+1)
				append tm_array (subline[11+tm_bv]as float)
			)
			append bone_ids tm_ids
			append weight_array tm_array
		)
		--print("共读取权重组==" +  weight_array.count as string)
    ) , -- end fn
--========================================================================================
--                                     取 三角面
--========================================================================================
    fn  getSkinFaces in_file=(
		while not eof in_file do 	                -- read until reach end of file
		(
			line=   readline  in_file 	            -- 读入一行
			subline = filterString  line " 	"		-- 用空格分解为文本数组
			if subline[1] == "#" do continue 	    -- 跳过注释行
				
			if  ( subline[1] == "Triangles:") then 
					(  
						num_face = subline[2]as integer             --  取得顶点数
						format " 取得三角面数=     %   \n"     num_face
						exit
					)
			else 
				continue
		)
		
		--==================取 每个三角面========= ============
		for v = 1 to num_face do
		(
			line=readline  in_file 	 
			subline = filterString  line " 	"
			
			append face_mat		((subline[3]as integer))
			append faces 		[ (subline[4]as integer)+1 ,(subline[5]as integer)+1, (subline[6]as integer)+1	]

		)
    )  --end fn    getSkinFaces
)  -- end struct LXOBJ

global	 boneCount 	
global	dummeyCount	
--========================================================================================
--                                      读骨骼总数
--========================================================================================
fn	readBoneNum		in_fileBnc=
(
		while not eof in_fileBnc do 	-- read until reach end of file
		( 
			line=	readline  in_fileBnc 	-- 读入一行
			subline = filterString  line " 	"		 	-- 用空格分解为文本数组
			if subline[1] == "#" do continue 	     -- 跳过注释行

			-- 寻找骨骼数量,此行定义如下: 	Bones: 30 Dummey: 6
			if subline[1] != "Bones:" then continue else exit	
		)
		---------------------		读入骨骼数		----------------------------
		boneCount = subline[2]as integer			--读入 骨骼数
		dummeyCount = subline[4]as integer			--读入 Dummey 数
 
		print ("骨骼总数=	" + (boneCount as string) + ";    Dummey总数= "+ (dummeyCount as string) 		)	
		
) 

global	num_skins		
--======================================================================================== 
--                                     读取模型
--========================================================================================
fn	readLxObj		in_file=
(
	while not eof in_file do 	-- read until reach end of file
	( 
		line=readline  in_file 	-- 读入一行
		subline = filterString  line " 	"		-- 用空格分解为文本数组
		if subline[1] == "#" do continue 	-- 跳过注释行, skip to next line
		if  ( subline[1] == "Static" and subline[2] == "Skins:" ) then 
		(  
			num_skins = subline[3] as integer       --取得 静态模型数量
			exit
		)
	) 
	format " 取得 静态子模型 总数=     %   \n"     num_skins 

	myobj = #()
	
	for i=1 to  num_skins   do
	(
		--      开始遍历所有子模型,通常 流星低模只有1个模型
		-- line=readline  in_file 				-- 跳过一行	"{"	

		myobj[i] = LXOBJ Id:i               --创建一个子模型
		myobj[i].getSkinName    in_file     -- 取模型名称
		line=readline  in_file 				-- 跳过一行	"{"	

		print 	("--------------- 	skin name = " + myobj[i].skin_name)
		myobj[i].getSkinMats    in_file     --取材质
		print 	("--------------- 	材质数量  = " + ( myobj[i].mats.count as string) )
		myobj[i].getSkinVerts   in_file     --取顶点
		myobj[i].getSkinFaces   in_file     --取面

		line=readline  in_file 				-- 跳过一行	"}"			-- 至此取得一个静态子模型
	)-- end for
	  
	  return	myobj
) -- end fn readMesh

--========================================================================================
--                                      Main()
--========================================================================================
fn 	mainFunc  argName=
(

--delete $* --删除现有模型
macros.run "Medit Tools" "clear_medit_slots"
	
--------------------		读入 skc 模型		-----------------------

--in_name = ((GetDir #export)+"/../scripts/SMDImporter/p9_300.skc") 

lx_objs 	= 	#()

if doesFileExist  argName then

--if in_name != undefined then
( 
	in_name = argName
	in_file = openFile in_name 	
	
	if in_file != undefined then
	(
		print ("   ---	开始读入流星[模型]文件:	"+ in_name)
		lx_objs = readLxObj in_file	
		close in_file 
		print ("   ---	流星[模型]文件读入完毕:	"+ in_name)	 
	)

)else(
	return NULL
)-- end if 	
--------------------		读入 bnc 骨骼		-----------------------
--in_bncName = ((GetDir #export)+"/../scripts/SMDImporter/p9.bnc") 

global lx_bones =#()	--这里使用全局变量，以便导入后用于其它脚本访问骨骼
tmp_path = getFilenamePath	argName
tmp_filename= 	getFilenameFile 	argName		--取纯文件名,无后缀名
subss = filterString   tmp_filename 	"_"		-- 取得 skc 文件名 里 _ 前的值, 如   p1_300.skc 取得 P1
in_bncName = (tmp_path + subss[1] + ".bnc" )
print	( "开始寻找配套骨骼文件== ["+ in_bncName + "]" )
if doesFileExist  in_bncName  then
( 
	bncFile = openFile in_bncName 	
	
	if bncFile != undefined then
	(
		--                               读入骨骼文件
		print ("   ---	开始读入流星[骨骼]文件:	"+ in_bncName)	
		readBoneNum	bncFile
		print ("	--- 		骨骼数量读入完成  共有骨骼 ==   " + boneCount as string)
	
		if	(boneCount != undefined )then
		(
			
			for j = 1 to (boneCount+ dummeyCount) do
			(	
				lx_bones[j] = LXBONE	boneId:j		-- 创建一个自定义骨骼结构,并赋序号
				lx_bones[j].get_Bone	bncFile		-- 取一个骨骼结构
			)
		)--end if
			
		close bncFile	--关闭骨骼文件
		print ("   ---	流星[骨骼]文件读入完毕:	"+ in_bncName)	
		
	)

)else(

	if ((queryBox ("没有在目录下找到“" + subss[1] + ".bnc”文件！\n\n是否手动指定BNC文件？")) !=false )then (
		bnc_name = getOpenFileName types:"流星bnc人物骨骼文件 (*.bnc)|*.bnc|All (*.*)|*.*|" caption:"打开bnc人物骨骼"
		if bnc_name != undefine then (
			bncFile = openFile bnc_name 	
			if bncFile != undefined then
			(
				--                               读入骨骼文件
				print ("   ---	开始读入流星[骨骼]文件:	"+ in_bncName)	
				readBoneNum	bncFile
				print ("	--- 		骨骼数量读入完成  共有骨骼 ==   " + boneCount as string)
			
				if	(boneCount != undefined )then
				(
					
					for j = 1 to (boneCount+ dummeyCount) do
					(	
						lx_bones[j] = LXBONE	boneId:j		-- 创建一个自定义骨骼结构,并赋序号
						lx_bones[j].get_Bone	bncFile		-- 取一个骨骼结构
					)
				)--end if
					
				close bncFile	--关闭骨骼文件
				print ("   ---	流星[骨骼]文件读入完毕:	"+ in_bncName)	
				
			)
		)else(
			print " 	***	 ERR!!!  没有取到合法的 骨骼文件 *.bnc"	
			return NULL	
		)
	)else(
		print " 	***	 ERR!!!  没有取到合法的 骨骼文件 *.bnc"	
		return NULL	
	)
)-- end if

--------------------		创建模型		-----------------------
lx_meshs	=#()
--print ("	***		开始创建模型")
for	i = 1 to lx_objs.count	do		-- 为每个模型创建
(
	cmats = multimaterial name: ("_mats_" + (i as string))	 numsubs:lx_objs[i].mats.count--多维材质
	--format "材质总数= % \n"	shas.count
	texon = 0 --贴图开关
	for  itx=1 to lx_objs[i].mats.count do
	(
		tname=""
		if	lx_objs[i].mats[itx].Tex != "" then
		(
			tname = texPath + lx_objs[i].mats[itx].Tex
			if texon == 0 then(
				while not (doesFileExist tname) do (
					if (queryBox ("没有在目录下找到“" + lx_objs[i].mats[itx].Tex + "”文件！\n\n是否手动指定？"))then (
						tex_name = getOpenFileName types:"贴图文件|*.jpg;*.tga;*.bmp;*.ifl|All (*.*)|*.*|" caption:"选择贴图" filename:lx_objs[i].mats[itx].Tex
						if tex_name != undefined then (
							texPath = getFilenamePath tex_name
							tname = tex_name
						)
					)else(
						if (queryBox ("是否记住选择？"))then (
							texon = 1
						)
						exit
					)
				)
			)
		)
		join
		--	cmats[itx] = meditMaterials[mitx]
		local subMat = standardmaterial name:( "mat" + (itx as string))
		--local	tmpmat =  standard diffuseMap:(Bitmaptexture fileName:	tname) 	showInViewport:true
		local dmap = bitmaptexture filename: tname
		subMat.maps[2] = dmap
		subMat.mapEnables[2] = true
		subMat.ambient = color ((lx_objs[i].mats[itx].amb[1] as float)*255.0) ((lx_objs[i].mats[itx].amb[2] as float)*255.0) ((lx_objs[i].mats[itx].amb[3] as float)*255.0)
		subMat.diffuse = color ((lx_objs[i].mats[itx].dif[1] as float)*255.0) ((lx_objs[i].mats[itx].dif[2] as float)*255.0) ((lx_objs[i].mats[itx].dif[3] as float)*255.0)
		subMat.specular = color ((lx_objs[i].mats[itx].spec[1] as float)*255.0) ((lx_objs[i].mats[itx].spec[2] as float)*255.0) ((lx_objs[i].mats[itx].spec[3] as float)*255.0)
		subMat.selfIllumColor = color ((lx_objs[i].mats[itx].emis[1] as float)*255.0) ((lx_objs[i].mats[itx].emis[2] as float)*255.0) ((lx_objs[i].mats[itx].emis[3] as float)*255.0)
		subMat.opacity = (lx_objs[i].mats[itx].opac as float)*100.0
		case ((lx_objs[i].mats[itx].opt) as name) of (
			#ALPHA:(
				subMat.diffuseMap.alphasource = 0
			)
			#INTENSITY:(
				subMat.diffuseMap.alphasource = 1
			)
			default:(
				subMat.diffuseMap.alphasource = 2
			)
		)
		if (lx_objs[i].mats[itx].twoside) as name == #TRUE then(
			subMat.twoSided = true
		)
		showTextureMap subMat dmap true
		
		cmats[itx] = submat
	)

	lx_meshs[i]  =      mesh    name:lx_objs[i].skin_name	 vertices:lx_objs[i].verts  materialIDs:lx_objs[i].face_mat   faces:lx_objs[i].faces  	tverts:lx_objs[i].uvs
	lx_meshs[i].material = cmats
	for  itx=1 to lx_objs[i].mats.count do
	(
		showTextureMap lx_meshs[i].material[itx]		on	--cmat[itx] meditMaterials[itx].diffuseMap on 
	)
	update lx_meshs[i]
	--setMeditMaterial 1 (standardMaterial selfIllumAmount:100) 
	--13. Build the faces
		BUILDTVFACES 	lx_meshs[i]	-- FALSE
		-- lx_meshs[i].materialIDs = #(0,1)
	--14. Set the UVW coordinates to the faces.
		for f = 1 to lx_objs[i].faces.count do
		(
		ftid = lx_objs[i].face_mat[f]+1
		setFaceMatID 	lx_meshs[i] 	f 	ftid
		--select lx_meshs[i].faces[f]
		--$.material = meditMaterials[ftid]
		SETTVFACE	 	lx_meshs[i] 	f	lx_objs[i].faces[f]
		)
	
	--lx_meshs[i].Material=		getMeditMaterial 1
	--lx_meshs[i].material=meditmaterials[2]

		
	update lx_meshs[i]
)-- end for
 print ("	***		创建模型完毕")
------------------------------------------------------------------------

------------------------------------------------------------------------
--                               连接骨骼	
print ("	***		开始连接骨骼")
	for i2= 1 to lx_bones.count do		--遍历所有已读入的骨骼,寻找此父名
	(
		if  lx_bones[i2].parentName != "" then		-- 当父名不为空,才寻父
		(
			for i3= 1 to lx_bones.count do	--再次遍历骨骼
			(
				case  lx_bones[i2].type of 	--	骨骼中有 bone 和 dummey 两种情况,	dummey的父名是 (b或d) 字节 加数字文值索引
				(
					1:	-- 是 bone
							if  ( lx_bones[i2].parentName == lx_bones[i3].boneName )	then		-- 如果此父的名字与遍历中相同
							(
								--zpoint[i2].parent=	zpoint[i3]						-- 指向父
								lx_bones[i2].parentId = lx_bones[i3].boneId
							)--end if
						
					2:	-- 是 dummey
						case  lx_bones[i2].parentName[1]  of 
						(
							"d"	:	(
										tmpS = lx_bones[i2].parentName;	
										ss = substring 	tmpS 	2 	(tmpS.count- 1)	-- 取得   parent d5 的 5 数值,注意 d5 表示dummey 5 在36块总骨骼中排序 36
										lx_bones[i2].parentId = (ss as integer	+31 )		-- 流星序号以0起,这里要 +31
									);
									
							"b"	:	(	tmpS = lx_bones[i2].parentName;	
										ss = substring 	tmpS 	2 	(tmpS.count- 1)	-- 取得   parent b25 的 25 数值
										lx_bones[i2].parentId = (ss as integer	+1 )		-- 流星序号以0起,这里要 +1
									)
									

						)--end case

					
				)--end case
				
			)--end for		
		)

	)-- end for
print ("	***		连接骨骼 完毕, 共有骨骼 ==" + lx_bones.count as string)
	------------------------------------------------------------------------
	--                               画出骨骼	
print ("	***		开始画出骨骼")
global	zpoint = #()	--	辅助点对象
	format "共要画出 % 块骨骼"	lx_bones.count

	for i =  1 to lx_bones.count do
	(
		zpoint[i] =	point 	name:("" + lx_bones[i].boneName )		size:0.2 	showLinks:true	--创建1个辅助点
		zpoint[i].isHidden	=	false		--!!!!这里隐藏了辅助点对象,如果需要可以打开
	)
	for i =  1 to lx_bones.count do
	(
		if  lx_bones[i].parentId != undefined  then
		(
			tmpI=	lx_bones[i].parentId
			zpoint[i].parent=	zpoint[ tmpI ]						-- 指向父
			
			--format " 连接骨骼		% 	到其父		% ,		父ID== 	% \n"	 lx_bones[i].boneName	lx_bones[i].parentName		lx_bones[i].parentId
			
			format "  bipbn[%] =		$'%' 	kid=% 	到其父		% ,		父ID== 	% \n"	i	 lx_bones[i].boneName	i	lx_bones[i].parentName		lx_bones[i].parentId
			in coordsys parent		-- 指明在父空间内设置 
			(
				zpoint[i].rotation	=	lx_bones[i].vrot	--!!! 注意: 必须先旋转再平移!
				zpoint[i].pos		= 	lx_bones[i].vpos 
			)	
		)else
		(
			zpoint[i].rotation	=	lx_bones[i].vrot			
			zpoint[i].pos		= 	lx_bones[i].vpos
		) -- end if
		

	)-- end for

global 	lxbs = #()

--////////////////////////////////////////////////////////////
--			以下生成30块基本系统骨骼和1个d_base 
--////////////////////////////////////////////////////////////

	
	--                               画出骨骼	结束
	------------------------------------------------------------------------
	
	disableSceneRedraw()	---------   取消重画, 可以提高速度,必须再用 enableSceneRedraw() 打开重画

	for i=1 to lx_meshs.count do 
	(


		
		skinMod = skin ()
		skinMod.rigid_vertices = false		--禁用刚体顶点
		skinMod.bone_Limit = 4
		select	lx_meshs[i]
		max 		modify mode		
		
		addmodifier 	lx_meshs[i] skinMod		-- 蒙皮修改器 , 以下将使用 此修改器的方法
		ms	=	lx_meshs[i].modifiers[#skin]
		
		for n=1 to 30 do 
		(
			if(n ==30) then
				skinOps.addbone skinMod zpoint[n] 	1	-- 向当前系统加入1个骨骼, 参数为 <skin> <boneNode> <is uptate =1 时即时刷新画面, =0 不刷新> 
			else
				skinOps.addbone skinMod zpoint[n] 	0
			
			print zpoint[n].name
		)
		
		modPanel.setCurrentObject skinMod

		_bid		=	lx_objs[i].bone_ids
		_weights 	= 	lx_objs[i].weight_array
		for n=1 to	lx_meshs[i].numVerts  do 
		(	local xx=1
			-- 为指定骨骼 设置 对指定顶点 的权重,先前设置的该骨骼对其它顶点的影响权重被保留,如果参数
			-- 骨骼和顶点都指定为数组,两者的长度必须相等.
			--参数说明:	skinOps.SetVertexWeights	<skin>	<vertex_Integer>	( <vertex_Bone_Integer> | <vertex_Bone_array> )	( <weight_Float> | <weight_Array> )
			/*
			_v1 = lx_objs[i].bone_v_count[n]
			if  _v1 >= 5 then (
				print ("n=="+ n as string + ",  i=="+ i as string)
				
				print (_v1 as string)
				print ("权重cont="+ _v1 as string + ", weights=="+ _bid[n] as string)
			)
			
			case _v1 of	-- 根据 权重数量选择 1,2,3个参数
			(
				--bone_ids =#(),      bone_v_count =#(),	weight_array =#(),	

				1:	skinOps.ReplaceVertexWeights  skinMod  n  (_bid[n][1]+xx)     (_weights[n][1])
				2:	skinOps.ReplaceVertexWeights  skinMod  n  #(_bid[n][1]+xx ,_bid[n][2]+xx)     #(_weights[n][1],_weights[n][2])
				3:	skinOps.ReplaceVertexWeights  skinMod  n  #(_bid[n][1]+xx,_bid[n][2]+xx,_bid[n][3]+xx)    #(_weights[n][1],_weights[n][2],_weights[n][3])
				4:	skinOps.ReplaceVertexWeights  skinMod n  #(_bid[n][1]+xx,_bid[n][2]+xx,_bid[n][3]+xx,_bid[n][4]+xx)    #(_weights[n][1],_weights[n][2],_weights[n][3],_weights[n][4])
			)*/
	
			skinOps.ReplaceVertexWeights  skinMod  n  _bid[n]     _weights[n]
			-- 以下命令是 替换权重 !
			-- skinOps.ReplaceVertexWeights sk j lbi lbw		
		)

		
	)

	enableSceneRedraw()	---------------- 充许重画
)	-- end function mainFunc

--=======================================================================
--				Main
--======================================================================
global lxPath
lxPath = ""
skc_name = getOpenFileName types:"流星skc人物模型文件 (*.skc)|*.skc|All (*.*)|*.*|" caption:"打开skc人物模型"
if skc_name != undefine then (
	mainFunc skc_name
)
