/*流星蝴蝶剑 skc bnc 导出脚本*/
/*0.1集成bnc导出*/
/*0.2增加ALPHA通道导出*/
/*0.3增加错误执行*/
/*0.4增加多个模型导出，不需要附加为一个模型*/
/*0.5修正多维材质报错*/
/*0.7优化材质算法，增加物理材质支持*/
/*0.7.1修复多维材质无法获取双面材质的bug*/
/*
0.8
修复材质无贴图时报错
使用纹理面导出减少UV错乱（不需要导出3DS整理纹理）
增加多修改器对象导出（可在蒙皮后修改uv，法线等。。。）
解除顶点5骨骼权重限制
增加自动清除0权重（低版本max可能不支持）
*/
/*
0.81
优化材质导出，导出文件无重复材质
优化面排序，解决附加模型后部分模型不显示的BUG（附加模型后请使用UVW编辑器焊接一次纹理顶点，减少无效顶点）
增加导出模式：
	1、纹理去重导出，减少文件顶点提高游戏加载速度，导出时间比较久(几万顶点的模型不推荐使用，可能使max文件无响应)
	2、全纹理导出，导出速度快，文件较大。(适合高精度模型导出，如导出文件中包含有“Bones 0”的顶点，请给模型添加UVW编辑器并焊接纹理顶点，将UVW编辑器放在蒙皮修改器后面)
*/
BipName = "Bip001" --骨骼的类名，不是Bip001时请手动更改

lxbone =#(
	--bone /*2是子3是父*/
	#("","b","d_base","1"),
	#(" Pelvis","bad_Pelvis","b","1"),
	#(" Spine","bau_Spine","bad_Pelvis","3"),
	#(" L Thigh","bad_L_Thigh","bau_Spine","1"),
	#(" L Calf","bad_L_Calf","bad_L_Thigh","1"),
	#(" L Foot","bad_L_Foot","bad_L_Calf","1"),
	#(" L Toe0","bbd_L_Toe0","bad_L_Foot","0"),
	#(" R Thigh","bad_R_Thigh","bau_Spine","1"),
	#(" R Calf","bad_R_Calf","bad_R_Thigh","1"),
	#(" R Foot","bad_R_Foot","bad_R_Calf","1"),
	#(" R Toe0","bbd_R_Toe0","bad_R_Foot","0"),
	#(" Spine1","bau_Spine1","bau_Spine","1"),
	#(" Neck","bau_Neck","bau_Spine1","3"),
	#(" Head","bau_Head","bau_Neck","0"),
	#(" L Clavicle","bau_L_Clavicle","bau_Neck","1"),
	#(" L UpperArm","bau_L_UpperArm","bau_L_Clavicle","1"),
	#(" L Forearm","bau_L_Forearm","bau_L_UpperArm","1"),
	#(" L Hand","bau_L_Hand","bau_L_Forearm","2"),
	#(" L Finger0","bbu_L_Finger0","bau_L_Hand","1"),
	#(" L Finger01","bbu_L_Finger01","bbu_L_Finger0","0"),
	#(" L Finger1","bbu_L_Finger1","bau_L_Hand","1"),
	#(" L Finger11","bbu_L_Finger11","bbu_L_Finger1","0"),
	#(" R Clavicle","bau_R_Clavicle","bau_Neck","1"),
	#(" R UpperArm","bau_R_UpperArm","bau_R_Clavicle","1"),
	#(" R Forearm","bau_R_Forearm","bau_R_UpperArm","1"),
	#(" R Hand","bau_R_Hand","bau_R_Forearm","2"),
	#(" R Finger0","bbu_R_Finger0","bau_R_Hand","1"),
	#(" R Finger01","bbu_R_Finger01","bbu_R_Finger0","0"),
	#(" R Finger1","bbu_R_Finger1","bau_R_Hand","1"),
	#(" R Finger11","bbu_R_Finger11","bbu_R_Finger1","0"),
	--Dummey
	#("d_base","d_base","NULL","0"),
	#(" HeadNub","d_top","b13","14"),
	#("d_wpnL","d_wpnL","d3","34"),
	#("d_wpnLP","d_wpnLP","b17","18"),
	#("d_wpnR","d_wpnR","d5","36"),
	#("d_wpnRP","d_wpnRP","b25","26")
)
struct LX_VERT(
	vv,
	tv,
	bid = #(),
	bweight = #()
)
struct LX_FACE(
	mid,
	fid = #()
)
fn xs var1 var2=(--1要保留小数点的数，2小数点位数
    var = var1 as float
    str = "0."+ var2 as string +"f"
    ret = formattedPrint var format:str
    return ret
)
fn matstr mat=(
	struct	LX_Tex(
		tex,
		col,
		amb,
		dif,
		spe,
		emi,
		opacity,
		option,
		twoside
	)	
	m = mat
	mtype = classof  m
	case mtype of (
		Standardmaterial:(/*标准材质*/
			aTex = LX_Tex()
			if classof m.diffuseMap == Bitmaptexture then(
				aTex.tex = m.diffuseMap.filename
				case m.diffuseMap.alphasource of
				(
					0 : aTex.option = "ALPHA"
					1 : aTex.option = "INTENSITY"
					2 : aTex.option = "NONE"
					default: aTex.option = "NONE"
				)
			)else(
				aTex.tex = "NONE"
				aTex.option = "NONE"
			)
			aTex.col	=	m.filterColor	--Color default: (color 127.5 127.5 127.5) -- animatable, alias: Filter_Color,The color transmitted through transparent or semi-transparent materials such as glass. 
			aTex.amb	=	m.ambient 	 	/	255.0		--Color default: (color 149.94 149.94 149.94) 	-- animatable; RGB color; Ambient_Color
			aTex.dif	=	m.diffuse 		/	255.0		--Color default: (color 149.94 149.94 149.94) 	-- animatable, alias: Diffuse_Color
			aTex.spe	=	m.specular 		/	255.0		--Color default: (color 229.5 229.5 229.5) 	-- animatable; Specular_Color
			aTex.emi	=	m.selfIllumColor	/	255.0	--自发光 <Standard>.selfIllumColor Color default: (color 0 0 0) -- animatable; Self_Illum_Color
			aTex.opacity	=	m.opacity 	/	100.0		--Float default: 100.0 -- animatable; percentage
			--双面
			case m.twoSided of
			(
				FALSE : aTex.twoside = "FALSE"
				TRUE : aTex.twoside = "TRUE"
				default: aTex.twoside = "FALSE"
			)
			_txt = stringstream ""
			texname = filenameFromPath aTex.tex
			format "%|" aTex.tex to:_txt
			format "  Material\n" to:_txt
			format "    Texture   %\n" texname to:_txt
			format "    ColorKey  % % % %\n" 0 0 0 0 to:_txt
			format "    Ambient   % % %\n" (xs aTex.amb.a 3) (xs aTex.amb.g 3) (xs aTex.amb.b 3) to:_txt
			format "    Diffuse   % % %\n" (xs aTex.dif.a 3) (xs aTex.dif.g 3) (xs aTex.dif.b 3) to:_txt
			format "    Specular  % % %\n" (xs aTex.spe.a 3) (xs aTex.spe.g 3) (xs aTex.spe.b 3) to:_txt
			format "    Emissive  % % %\n" (xs aTex.emi.a 3) (xs aTex.emi.g 3) (xs aTex.emi.b 3) to:_txt
			format "    Opacity   %\n" (xs aTex.opacity 3) to:_txt
			format "    Option    %\n" aTex.option to:_txt
			format "    TwoSide   %\n" aTex.twoside to:_txt	
			return (_txt as string)
		)/*标准材质*/
		PhysicalMaterial:(/*物理材质*/
			aTex = LX_Tex()
			if classof m.base_color_map == Bitmaptexture then(
				aTex.tex = m.base_color_map.filename
				case m.base_color_map.alphasource of
				(
					0 : aTex.option = "ALPHA"
					1 : aTex.option = "INTENSITY"
					2 : aTex.option = "NONE"
					default: aTex.option = "NONE"
				)
			)else(
				aTex.tex = "NONE"
				aTex.option = "NONE"
			)
			aTex.col	=	m.coat_color	--Color default: (color 127.5 127.5 127.5) -- animatable, alias: Filter_Color,The color transmitted through transparent or semi-transparent materials such as glass. 
			aTex.amb	=	m.Base_Color 	 	/	255.0		--Color default: (color 149.94 149.94 149.94) 	-- animatable; RGB color; Ambient_Color
			aTex.dif	=	m.refl_color 		/	255.0		--Color default: (color 149.94 149.94 149.94) 	-- animatable, alias: Diffuse_Color
			aTex.spe	=	m.trans_color 		/	255.0		--Color default: (color 229.5 229.5 229.5) 	-- animatable; Specular_Color
			aTex.emi	=	m.emit_color	/	255.0	--自发光 <Standard>.selfIllumColor Color default: (color 0 0 0) -- animatable; Self_Illum_Color
			aTex.opacity	=	1-m.Transparency		--Float default: 100.0 -- animatable; percentage
			--双面
			aTex.twoside = "TRUE" --物理材质默认开启双面

			_txt = stringstream ""
			texname = filenameFromPath aTex.tex
			format "%|" aTex.tex to:_txt
			format "  Material\n" to:_txt
			format "    Texture   %\n" texname to:_txt
			format "    ColorKey  % % % %\n" 0 0 0 0 to:_txt
			format "    Ambient   % % %\n" (xs aTex.amb.a 3) (xs aTex.amb.g 3) (xs aTex.amb.b 3) to:_txt
			format "    Diffuse   % % %\n" (xs aTex.dif.a 3) (xs aTex.dif.g 3) (xs aTex.dif.b 3) to:_txt
			format "    Specular  % % %\n" (xs aTex.spe.a 3) (xs aTex.spe.g 3) (xs aTex.spe.b 3) to:_txt
			format "    Emissive  % % %\n" (xs aTex.emi.a 3) (xs aTex.emi.g 3) (xs aTex.emi.b 3) to:_txt
			format "    Opacity   %\n" (xs aTex.opacity 3) to:_txt
			format "    Option    %\n" aTex.option to:_txt
			format "    TwoSide   %\n" aTex.twoside to:_txt	
			return (_txt as string)
		)/*物理材质*/
		default:(
			return undefined
		)
	)
)
fn getmats=(
	mall = sceneMaterials
	ret = #()
	for i = 1 to mall.count do(
		m = mall[i]
		mtype = classof  m
		case mtype of (
			Standardmaterial:(/*单材质*/
				AppEnd ret m
			)/*单材质*/
			PhysicalMaterial:(/*物理材质*/
				AppEnd ret m
			)/*物理材质*/
			Multimaterial:(/*多维材质*/
				for j = 1 to m.numsubs do
				(
					mtype1 = classof  m.materialList[j]
					case mtype1 of (
						Standardmaterial:(	
							append	ret m.materialList[j]
						)
						PhysicalMaterial:(
							append	ret m.materialList[j]
						)
						default:(body)
					)
				)
			)/*多维材质*/
			default:(
			)
		)
	)
	return ret	
)
fn getboneid skinmod=(
	ret = #()
	boneNameArray = #()
	/*取骨骼序号*/
	boneNum	=	skinOps.GetNumberBones skinmod /*蒙皮系统中 骨骼数量*/
	for m=1	to boneNum do
	(
		boneNameArray[m] = skinOps.GetBoneName skinmod  m  1
		for b = 1 to 36 do(
			if (lxbone[b][2] == boneNameArray[m]) then (
				ret[m] = b-1
				continue
			)
			if (BipName + lxbone[b][1] == boneNameArray[m]) then (
				ret[m] = b-1
				continue
			)
		)
	)/*取骨骼序号结束*/
	return ret
)
fn getdat objs=(
	lx_mats = #()--材质
	faces = #()
	verts = #()
	for i = 1 to objs.count do(
		if objs[i].modifiers[#Skin] == undefined then
		(
			MessageBox(objs[i].name + " 没有蒙皮修改器!") title:"错误!" beep:false
			select objs[i]
			return undefined
		)
		/*
		if classof objs[i].modifiers[1] != Skin then(
			MessageBox("请将对象 " + objs[i].name + " 蒙皮修改器移动到第一位，防止其它修改器无效！") title:"提示!" beep:false
			select objs[i]
			max modify mode
			modPanel.setCurrentObject objs[i].modifiers[#Skin] node:objs[i]
			return undefined
		)
		*/
		try (
			if snapshotAsMesh objs[i] == undefined then(
				MessageBox("对象 " + objs[i].name + " 没有网格！") title:"提示!" beep:false
				select objs[i]
				return undefined
			)
		) catch (
			MessageBox("对象 " + objs[i].name + " 不能转网格！") title:"提示!" beep:false
			select objs[i]
			return undefined
		)
	)
	for o = 1 to objs.count do(
		obj = objs[o]
		theSkinMod = obj.modifiers[#Skin]
		/*取面和顶点*/
		tmpmesh = snapshotAsMesh obj
		select obj
		max modify mode
		modPanel.setCurrentObject theSkinMod node:obj
		subObjectLevel = 1
		--skinOps.RemoveZeroWeights theSkinMod --清除0权重

		tvvnum = tmpmesh.numtverts --纹理顶点数
		if tvvnum == 0 then(
			MessageBox("对象 " + obj.name + " 没有UV纹理！") title:"提示!" beep:false
			return undefined
		)
		fmid = -1
		fmids = #()
		lxIDs = getboneid theSkinMod
		if classof obj.material == Multimaterial then(
			for m = 1 to obj.material.numsubs do(
				mat_str = matstr obj.material.materialList[m]
				if mat_str == undefined then(
					fmids[m] = 0
				)else if findItem lx_mats mat_str == 0 then(
					append lx_mats mat_str
					fmids[m] = lx_mats.count
				)else(
					fmids[m] = findItem lx_mats mat_str
				)
			)
		)else(
			mat_str = matstr obj.material
			if mat_str == undefined then(
				fmid = 0
			)else if findItem lx_mats mat_str == 0 then(
				append lx_mats mat_str
				fmid = lx_mats.count
			)else(
				fmid = findItem lx_mats mat_str
			)
		)
		vernum = verts.count
		for i = 1 to tmpmesh.numfaces do(
			ftmp = LX_FACE()
			if classof obj.material == Multimaterial then(
				id = getFaceMatID tmpmesh i
				fmid = fmids[id]
			)
			ftmp.mid = fmid
			vvf = getFace tmpmesh i
			tvf = getTVFace tmpmesh i
			for k = 1 to 3 do(
				--_txt = stringstream ""
				vtmp = LX_VERT()
				vtmp.vv = getVert tmpmesh vvf[k]
				--format "    v % % %" (xs vv.x 5) (xs vv.y 5) (xs vv.z 5) to:_txt
				vtmp.tv = getTVert tmpmesh tvf[k]
				--format " vt % %" (xs tv.x 5) (xs tv.y 5) to:_txt
				bnum = skinOps.GetVertexWeightCount theSkinMod vvf[k]		-- 取所有对此顶点有影响的骨骼总数						
				if bnum < 1 then 
				(
					errmsg = obj.name + " 顶点 [" + vvf[k] as string + "] 没有被赋于权重！\r\n [ 每个顶点都要有权重才可导出 ]."
					MessageBox errmsg
					return undefined
				)
				for cnt= 1 to bnum do
				(
					tmpI = skinOps.GetVertexWeightBoneID theSkinMod vvf[k] cnt	 -- 取权重骨骼序号,注意第3个参数 i 不是36个骨骼总数序列,而是有权重序列里序号
					tmpF = skinOps.GetVertexWeight theSkinMod vvf[k] cnt	 -- 取权重,注意第3个参数 i 不是36个骨骼总数序列,而是有权重序列里序号
					if (xs tmpF 5) as float != 0.0 then(
						append vtmp.bid lxIDs[tmpI]
						append vtmp.bweight tmpF
					)
				)
				verts[vernum + tvf[k]] = vtmp
				ftmp.fid[k] = vernum + (tvf[k] as integer)
			)
			append faces ftmp
		)
	)
	return #(lx_mats,verts,faces)
)
fn getboc=(
	BncArray = #() /*寄存bone骨骼名称*/
	/*创建bone骨骼*/
	NewBnc = Bone length:0.2 width:0.2 height:0.2;
	NewBnc.name = "Bnc_NULL";
	AppEnd BncArray NewBnc.name
		
	for i = 1 to lxbone.count do
	(
		NewBnc = Bone length:0.2 width:0.2 height:0.2;
		NewBnc.name = "Bnc_" + lxbone[i][2];
		AppEnd BncArray NewBnc.name
	)
	/*对位bone骨骼*/
	for i = 1 to lxbone.count do
	(
		if getNodeByName (lxbone[i][2]) != undefined then
		(
			bnc = getNodeByName (lxbone[i][2])
			--format "骷髅%：%\n" i bnc
			newbnc =  getNodeByName ("Bnc_" + lxbone[i][2])
			try(
				newbnc.rotation = inverse(((Biped.getTransform bnc #rotation) as EulerAngles) as quat)
				newbnc.pos = Biped.getTransform bnc #pos
			)catch(
				newbnc.rotation = bnc.rotation
				newbnc.pos = bnc.pos
			)
		)
		if getNodeByName (BipName + lxbone[i][1]) != undefined then
		(
			bnc = getNodeByName (BipName + lxbone[i][1])
			--format "骷髅%：%\n" i bnc
			newbnc =  getNodeByName ("Bnc_" + lxbone[i][2])
			try(
				newbnc.rotation = inverse(((Biped.getTransform bnc #rotation) as EulerAngles) as quat)
				newbnc.pos = Biped.getTransform bnc #pos
			)catch(
				newbnc.rotation = bnc.rotation
				newbnc.pos = bnc.pos
			)
		)
	)
	/*连接bone骨骼*/
	for i = 1 to lxbone.count do
	(
		if i <= 31 then
		(
			bnc = getNodeByName ("Bnc_" + lxbone[i][2])
			bnc.parent = getNodeByName ("Bnc_" + lxbone[i][3]);
		)else(
			bnc = getNodeByName ("Bnc_" + lxbone[i][2])
			id = lxbone[i][4] as Integer
			bnc.parent = getNodeByName ("Bnc_" + lxbone[id][2]);
		)
	)
	_txt = stringstream ""
	format "# Character Bone Export for Interserv\n"	to:_txt	
	format "# Skin For Lxres.com Creation Time %\n" LocalTime to:_txt	
	format "Bones: % Dummey: %\n"		30		6	to:_txt
	for n = 1 to 36 do
	(
		nod = getnodebyname  ("Bnc_" + lxbone[n][2])	 ignoreCase:true
		if nod== undefined then
		(
			continue
		)
		if n <=30 then
		(
			format "bone %\n" 		lxbone[n][2]		to:_txt
			
		)else (
			format "Dummey %\n" 	lxbone[n][2]		to:_txt
		)
		format "{\n" 	 					to:_txt
		
		if n <=30 then
		(
			format "  parent %\n" 		lxbone[n][3]			to:_txt
		)else(
			format "  parent %\n" 		lxbone[n][3]			to:_txt
		)
		--select nod
		in coordsys parent		-- 指明在父空间内设置 
		(
			px = xs nod.pos.x 5
			py = xs nod.pos.y 5
			pz = xs nod.pos.z 5
			
			qw = xs nod.rotation.w 5
			qx = xs nod.rotation.x 5
			qy = xs nod.rotation.y 5
			qz = xs nod.rotation.z 5
			
			format "  pivot  % % %\n" px py pz		to:_txt
			format "  quaternion % % % %\n" qw  qx  qy  qz 		to:_txt		
		)

		if n <=30 then
		(
			format "  children %\n" 	lxbone[n][4]		to:_txt		--	此处不能用	nod.children.count	，因为会包含其它非流星节点
		)

		format "}\n" 	 					to:_txt
	)
	/*删除bone骨骼*/
	for i = 1 to BncArray.count do
	(
		bnc = getNodeByName (BncArray[i])
		delete bnc
	)
	return (_txt as string)
)
fn getskc objs=(
	dat = getdat objs
	texs = #()
	if dat == undefined then(
		return undefined
	)
	_txt = stringstream ""
	format "# Character Skin Export For Interserv\n"	to:_txt	
	format "# Skin For Lxres.com Creation Time %\n" LocalTime to:_txt	
	format "Static Skins: % Dynamic Skins: %\n" 	1	0	 to:_txt
	/*开始导出*/
	format "Static Skin %\n" objs[1].name to:_txt
	format "{\n" to:_txt
	/*材质导出*/
	format "  Materials: %	\n" dat[1].count to:_txt
	for i = 1 to dat[1].count do(
		str1 = filterString dat[1][i] "|"--分割
		append texs str1[1]
		format "%" str1[2] to:_txt
	)
	format "  Vertices: %\n" dat[2].count to:_txt
	for i = 1 to dat[2].count do(
		if dat[2][i] == undefined then(
			format "    v 0.0 0.0 0.0 vt 0.0 0.0 Bones 0\n" to:_txt
		)else(
			format "    v % % %" (xs dat[2][i].vv.x 5) (xs dat[2][i].vv.y 5) (xs dat[2][i].vv.z 5) to:_txt
			format " vt % %" (xs dat[2][i].tv.x 5) (xs dat[2][i].tv.y 5) to:_txt
			format " Bones %" dat[2][i].bid.count to:_txt
			for bon = 1 to dat[2][i].bid.count do(
				format " % %" dat[2][i].bid[bon] (xs dat[2][i].bweight[bon] 5) to:_txt
			)
			format "\n" to:_txt
		)
	)
	format "  Triangles: %\n" dat[3].count to:_txt
	for m = 1 to dat[1].count do(
		for i = 1 to dat[3].count do(
			if dat[3][i].mid == m then(
				format 	"    f %  % % % %\n" 3 (dat[3][i].mid-1) (dat[3][i].fid[1]-1) (dat[3][i].fid[2]-1) (dat[3][i].fid[3]-1) to:_txt
			)
		)
	)
	format "}\n" to:_txt -- 最后必须加 } 结束
	return #(texs,(_txt as string))
)
fn getdat2 objs=(
	lx_mats = #()--材质
	faces = #()
	verts = #()
	for i = 1 to objs.count do(
		if objs[i].modifiers[#Skin] == undefined then
		(
			MessageBox(objs[i].name + " 没有蒙皮修改器!") title:"错误!" beep:false
			select objs[i]
			return undefined
		)
		/*
		if classof objs[i].modifiers[1] != Skin then(
			MessageBox("请将对象 " + objs[i].name + " 蒙皮修改器移动到第一位，防止其它修改器无效！") title:"提示!" beep:false
			select objs[i]
			max modify mode
			modPanel.setCurrentObject objs[i].modifiers[#Skin] node:objs[i]
			return undefined
		)
		*/
		try (
			if snapshotAsMesh objs[i] == undefined then(
				MessageBox("对象 " + objs[i].name + " 没有网格！") title:"提示!" beep:false
				select objs[i]
				return undefined
			)
		) catch (
			MessageBox("对象 " + objs[i].name + " 不能转网格！") title:"提示!" beep:false
			select objs[i]
			return undefined
		)
	)
	for o = 1 to objs.count do(
		obj = objs[o]
		theSkinMod = obj.modifiers[#Skin]
		/*取面和顶点*/
		tmpmesh = snapshotAsMesh obj
		select obj
		max modify mode
		modPanel.setCurrentObject theSkinMod node:obj
		subObjectLevel = 1
		--skinOps.RemoveZeroWeights theSkinMod --清除0权重

		tvvnum = tmpmesh.numtverts --纹理顶点数
		if tvvnum == 0 then(
			MessageBox("对象 " + obj.name + " 没有UV纹理！") title:"提示!" beep:false
			return undefined
		)
		fmid = -1
		fmids = #()
		lxIDs = getboneid theSkinMod
		if classof obj.material == Multimaterial then(
			for m = 1 to obj.material.numsubs do(
				mat_str = matstr obj.material.materialList[m]
				if mat_str == undefined then(
					fmids[m] = 0
				)else if findItem lx_mats mat_str == 0 then(
					append lx_mats mat_str
					fmids[m] = lx_mats.count
				)else(
					fmids[m] = findItem lx_mats mat_str
				)
			)
		)else(
			mat_str = matstr obj.material
			if mat_str == undefined then(
				fmid = 0
			)else if findItem lx_mats mat_str == 0 then(
				append lx_mats mat_str
				fmid = lx_mats.count
			)else(
				fmid = findItem lx_mats mat_str
			)
		)
		for i = 1 to tmpmesh.numfaces do(
			ftmp = LX_FACE()
			if classof obj.material == Multimaterial then(
				id = getFaceMatID tmpmesh i
				fmid = fmids[id]
			)
			ftmp.mid = fmid
			vvf = getFace tmpmesh i
			tvf = getTVFace tmpmesh i
			for k = 1 to 3 do(
				_txt = stringstream ""
				vv = getVert tmpmesh vvf[k]
				format "    v % % %" (xs vv.x 5) (xs vv.y 5) (xs vv.z 5) to:_txt
				tv = getTVert tmpmesh tvf[k]
				format " vt % %" (xs tv.x 5) (xs tv.y 5) to:_txt
				bnum = skinOps.GetVertexWeightCount theSkinMod vvf[k]		-- 取所有对此顶点有影响的骨骼总数						
				if bnum < 1 then 
				(
					errmsg = obj.name + " 顶点 [" + vvf[k] as string + "] 没有被赋于权重！\r\n [ 每个顶点都要有权重才可导出 ]."
					MessageBox errmsg
					return undefined
				)
				boid = #() --骨骼id
				bowe = #() --骨骼权重
				for cnt= 1 to bnum do
				(
					tmpI = skinOps.GetVertexWeightBoneID theSkinMod vvf[k] cnt	 -- 取权重骨骼序号,注意第3个参数 i 不是36个骨骼总数序列,而是有权重序列里序号
					tmpF = skinOps.GetVertexWeight theSkinMod vvf[k] cnt	 -- 取权重,注意第3个参数 i 不是36个骨骼总数序列,而是有权重序列里序号
					wei = xs tmpF 5
					if wei as float != 0.0 then(
						append boid lxIDs[tmpI]
						append bowe wei
					)
				)
				format " Bones %" boid.count to:_txt
				for bon = 1 to boid.count do(
					format " % %" boid[bon] bowe[bon] to:_txt
				)
				format "\n" 	to:_txt
				if findItem verts (_txt as string) == 0 then(
					append verts (_txt as string)
					ftmp.fid[k] = verts.count
				)else(
					ftmp.fid[k] = findItem verts (_txt as string)
				)
			)
			_txt = stringstream ""
			format 	"    f %  % % % %\n" 3 (ftmp.mid-1) (ftmp.fid[1]-1) (ftmp.fid[2]-1) (ftmp.fid[3]-1) to:_txt
			append faces #(ftmp.mid,(_txt as string))
		)
	)
	return #(lx_mats,verts,faces)
)
fn getskc2 objs=(
	dat = getdat2 objs
	texs = #()
	if dat == undefined then(
		return undefined
	)
	_txt = stringstream ""
	format "# Character Skin Export For Interserv\n"	to:_txt	
	format "# Skin For Lxres.com Creation Time %\n" LocalTime to:_txt	
	format "Static Skins: % Dynamic Skins: %\n" 	1	0	 to:_txt
	/*开始导出*/
	format "Static Skin %\n" objs[1].name to:_txt
	format "{\n" to:_txt
	/*材质导出*/
	format "  Materials: %	\n" dat[1].count to:_txt
	for i = 1 to dat[1].count do(
		str1 = filterString dat[1][i] "|"--分割
		append texs str1[1]
		format "%" str1[2] to:_txt
	)
	format "  Vertices: %\n" dat[2].count to:_txt
	for i = 1 to dat[2].count do(
		format "%" dat[2][i] to:_txt
	)
	format "  Triangles: %\n" dat[3].count to:_txt
	for m = 1 to dat[1].count do(
		for i = 1 to dat[3].count do(
			if dat[3][i][1] == m then(
				format "%" dat[3][i][2] to:_txt
			)
		)
	)
	format "}\n" to:_txt -- 最后必须加 } 结束
	return #(texs,(_txt as string))
)
fn out=(
	out_file = ""
	objs = #()
	objs = selectByName title:"选择要导出的部件" ButtonText:"导出" --filter:obj_filt /*只显示可编辑网格的模型*/
	if objs == undefined then (return undefined)--取消时返回-2
	if objs.count == 0 then (return undefined)--没有选择模型时返回-1
	boc = getboc()
	dat = #()
	if ((queryBox ("使用去重导出减少游戏资源占用，高精度可能会无响应！")) !=false )then (
		dat = getskc2 objs
	)else(
		dat = getskc objs
	)
	if dat == undefined then(
		return undefined
	)
	texs = dat[1]
	skc = dat[2]
	out_name = getSaveFileName types:"流星SKC文件 (*.skc)|*.skc|All (*.*)|*.*|" caption:"导出SKC文件"
	if out_name == undefine then (return undefined)/*取消保存时返回0*/
	
	exportName = getFilenameFile out_name/*寄存导出名字*/
	out_dir	= getFilenamePath out_name/*寄存导出路径*/
	try(
		out_file = createfile out_name /*创建输出文件*/
	)
	catch(
		MessageBox(exportName + ".skc无法写入，请检查是否被占用!") title:"错误!" beep:false
		return undefined
	)
	format "%" skc to:out_file
	close out_file
	if ((queryBox (exportName + ".skc生成成功！\n\n是否生成" + exportName + "_300.skc和" + exportName + "_800.skc？\n\n")) !=false )then (
		skc_dir = (out_dir + exportName + "_300.skc")
		if doesFileExist  skc_dir  then
		(
			deleteFile skc_dir
			copyFile out_name skc_dir
		)else(
			copyFile out_name skc_dir
		)
		skc_dir = (out_dir + exportName + "_800.skc")
		if doesFileExist  skc_dir  then
		(
			deleteFile skc_dir
			copyFile out_name skc_dir
		)else(
			copyFile out_name skc_dir
		)
	)
	out_name = out_dir + exportName + ".bnc"
	try(
		out_file = createfile out_name /*创建输出文件*/
	)
	catch(
		MessageBox(exportName + ".bnc无法写入，请检查是否被占用!") title:"错误!" beep:false
		return undefined
	)
	format "%" boc to:out_file
	close out_file
	if (queryBox ("是否拷贝有效贴图文件到导出目录？") !=false )then (
		for i = 1 to texs.count do(
			texname = filenameFromPath texs[i]
			copyFile texs[i] (out_dir + texname)
		)
	)
	MessageBox("导出完成!") title:"提示!" beep:false
)

out()
