struct AmbArray
(
	id,
	BoneArray = #(),
	DummyArray = #()
)
struct AmbDat
(
	pos = #(),
	rot = #()
)
ambpath = undefined
zwpnl = ""
zwpnr = ""
ambarr = #()
lxbone =#(
	--bone /*2是子3是父*/
	#("","b","d_base","1"),
	#(" Pelvis","bad_Pelvis","b","1"),
	#(" Spine","bau_Spine","bad_Pelvis","3"),
	#(" L Thigh","bad_L_Thigh","bau_Spine","1"),
	#(" L Calf","bad_L_Calf","bad_L_Thigh","1"),
	#(" L Foot","bad_L_Foot","bad_L_Calf","1"),
	#(" L Toe0","bbd_L_Toe0","bad_L_Foot","0"),
	#(" R Thigh","bad_R_Thigh","bau_Spine","1"),
	#(" R Calf","bad_R_Calf","bad_R_Thigh","1"),
	#(" R Foot","bad_R_Foot","bad_R_Calf","1"),
	#(" R Toe0","bbd_R_Toe0","bad_R_Foot","0"),
	#(" Spine1","bau_Spine1","bau_Spine","1"),
	#(" Neck","bau_Neck","bau_Spine1","3"),
	#(" Head","bau_Head","bau_Neck","0"),
	#(" L Clavicle","bau_L_Clavicle","bau_Neck","1"),
	#(" L UpperArm","bau_L_UpperArm","bau_L_Clavicle","1"),
	#(" L Forearm","bau_L_Forearm","bau_L_UpperArm","1"),
	#(" L Hand","bau_L_Hand","bau_L_Forearm","2"),
	#(" L Finger0","bbu_L_Finger0","bau_L_Hand","1"),
	#(" L Finger01","bbu_L_Finger01","bbu_L_Finger0","0"),
	#(" L Finger1","bbu_L_Finger1","bau_L_Hand","1"),
	#(" L Finger11","bbu_L_Finger11","bbu_L_Finger1","0"),
	#(" R Clavicle","bau_R_Clavicle","bau_Neck","1"),
	#(" R UpperArm","bau_R_UpperArm","bau_R_Clavicle","1"),
	#(" R Forearm","bau_R_Forearm","bau_R_UpperArm","1"),
	#(" R Hand","bau_R_Hand","bau_R_Forearm","2"),
	#(" R Finger0","bbu_R_Finger0","bau_R_Hand","1"),
	#(" R Finger01","bbu_R_Finger01","bbu_R_Finger0","0"),
	#(" R Finger1","bbu_R_Finger1","bau_R_Hand","1"),
	#(" R Finger11","bbu_R_Finger11","bbu_R_Finger1","0"),
	--Dummey
	#("d_base","d_base","NULL","0"),
	#(" HeadNub","d_top","b13","14","bau_Head"),
	#("d_wpnL","d_wpnL","d3","34","d_wpnLP"),
	#("d_wpnLP","d_wpnLP","b17","18","bau_L_Hand"),
	#("d_wpnR","d_wpnR","d5","36","d_wpnRP"),
	#("d_wpnRP","d_wpnRP","b25","26","bau_R_Hand")
)

--AMB文件头
bob = #(66,65,78,73,77) --BANIM
--辅助点名
dub = #(
	#(78,85,76,76,0),--NULL
	#(98,49,51,0,0),--b13
	#(100,51,0,0,0),--d3
	#(98,49,55,0,0),--b17
	#(100,53,0,0,0),--d5
	#(98,50,53,0,0) --b25
)
--定义一个仅旋转支点的函数 
function RotatePivotOnly obj rotation=(
	local rotValInv=inverse(rotation as quat) 
	animate off in coordsys local obj.rotation*=RotValInv 
	obj.objectoffsetrot*=RotValInv 
	obj.objectoffsetpos*=RotValInv 
)
function newbip var id=(--id 0提示 1不提示
	if var == undefined or var == "" then(
		una = ""
	)else(
		una = (var as string) + "_"
	)
	if id != undefined and (id as integer) == 0 then(
		for i = 1 to lxbone.count do
		(
			if getNodeByName (una + lxbone[i][2]) != undefined then(
				if ((queryBox ("任务中已存在同名对象！\n是否继续？")) == false )then (
					return -1
				)else(
					exit
				)	
			)
		)	
	)
	ret = #()
	bipObj = biped.createNew 37 -90 [0,0,35.5]  arms:true  neckLinks:1\
	spineLinks:2 legLinks:3 tailLinks:0 ponyTail1Links:0 \
	ponyTail2Links:0 fingers:2 fingerLinks:2 toes:1\
	toeLinks:1 ankleAttach:0.3 trianglePelvis:false \
	prop1Exists:false prop2Exists:false prop3Exists:false \
	forearmTwistLinks:0

	Base = Dummy length:0.2 width:0.2 height:0.2;
	Base.boxsize  = [0.8,0.8,0.8]
	Base.name = una + "d_base";
	bipObj.parent = Base;
	append ret Base

	wpnRP = Dummy length:0.2 width:0.2 height:0.2;
	wpnRP.boxsize  = [0.8,0.8,0.8]
	wpnRP.name = una + "d_wpnRP";
	append ret wpnRP

	R_Finger1 =  getNodeByName (bipObj.name + " R Finger1");
	wpnRP.rotation = eulerangles 0 90 0;

	R_Finger1_pos = Biped.getTransform R_Finger1 #pos;
	wpnRP.pos = [R_Finger1_pos.x + 0.6,R_Finger1_pos.y,R_Finger1_pos.z]
	R_Hand =  getNodeByName (bipObj.name + " R Hand");
	wpnRP.parent = R_Hand;

	wpnR = Dummy length:0.2 width:0.2 height:0.2;
	wpnR.boxsize  = [0.8,0.8,0.8]
	wpnR.name = una + "d_wpnR";
	wpnR.rotation = wpnRP.rotation
	wpnR.pos = wpnRP.pos
	wpnR.parent = wpnRP;
	append ret wpnR

	wpnLP = Dummy length:0.2 width:0.2 height:0.2;
	wpnLP.boxsize  = [0.8,0.8,0.8]
	wpnLP.name = una + "d_wpnLP";
	append ret wpnLP

	L_Finger1 =  getNodeByName (bipObj.name + " L Finger1");
	wpnLP.rotation = eulerangles 0 -90 0;

	L_Finger1_pos = Biped.getTransform L_Finger1 #pos;
	wpnLP.pos = [L_Finger1_pos.x - 0.6,L_Finger1_pos.y,L_Finger1_pos.z]

	L_Hand =  getNodeByName (bipObj.name + " L Hand");
	wpnLP.parent = L_Hand;

	wpnL = Dummy length:0.2 width:0.2 height:0.2;
	wpnL.boxsize  = [0.8,0.8,0.8]
	wpnL.name = una + "d_wpnL";
	wpnL.rotation = wpnLP.rotation
	wpnL.pos = wpnLP.pos
	wpnL.parent = wpnLP;
	append ret wpnL

	BipName = bipObj.name
	for i = 1 to lxbone.count do(
		bo = getNodeByName (BipName + lxbone[i][1])
		if bo != undefined then(
			bo.name = una + lxbone[i][2]
			append ret bo	
		)
	)
	bo = getNodeByName (BipName + " R Toe0Nub")
	if bo != undefined do
	bo.name = una + "bbd_R_Toe0Nub"
	append ret bo

	bo = getNodeByName (BipName + " R Finger1Nub")
	if bo != undefined do
	bo.name = una + "bbu_R_Finger1Nub"
	append ret bo

	bo = getNodeByName (BipName + " R Finger0Nub")
	if bo != undefined do
	bo.name = una + "bbu_R_Finger0Nub"
	append ret bo

	bo = getNodeByName (BipName + " L Toe0Nub")
	if bo != undefined do
	bo.name = una + "bbd_L_Toe0Nub"
	append ret bo

	bo = getNodeByName (BipName + " L Finger1Nub")
	if bo != undefined do
	bo.name = una + "bbu_L_Finger1Nub"

	bo = getNodeByName (BipName + " L Finger0Nub")
	if bo != undefined do
	bo.name = una + "bbu_L_Finger0Nub"
	append ret bo

	bo = getNodeByName (BipName + " Footsteps")
	if bo != undefined do
	bo.name = una + "bad_Footsteps"
	append ret bo
	return ret
)
function newbon var id=( --id 0新建 1导出对位
	/*创建bone骨骼*/
	if var == undefined or var == "" then(
		una = ""
	)else(
		una = (var as string) + "_"
	)
	case (id as integer) of (
		0:(
			for i = 1 to lxbone.count do
			(
				if getNodeByName (una + lxbone[i][2]) != undefined then(
					if ((queryBox ("任务中已存在同名对象！\n是否继续？")) == false )then (
						return -1
					)else(
						exit
					)
				)
			)
			bips = newbip "" 1
			ret = #()
			tra = #()
			for i = 1 to bips.count do
			(
				if bips[i].name == "bbu_R_Finger1Nub" do continue
				if bips[i].name == "bbu_L_Finger1Nub" do continue
				if bips[i].name == "bbu_R_Finger0Nub" do continue
				if bips[i].name == "bbu_L_Finger0Nub" do continue
				if bips[i].name == "bbd_R_Toe0Nub" do continue
				if bips[i].name == "bbd_L_Toe0Nub" do continue
				if bips[i].name == "bad_Footsteps" do continue
				--point 	name:("" + lx_bones[i].boneName )		size:0.2 	showLinks:true
				bon = Bone size:0.2;
				bon.name = una + bips[i].name;
				bon.transform = bips[i].transform
				AppEnd ret bon
				append tra bips[i].transform
			)
			--return ret		
			delete bips
			/*连接bone骨骼*/
			for i = 1 to lxbone.count do
			(
				if i < 31 then(
					for j = 1 to ret.count do(
						if ret[j].name == una + lxbone[i][2] then (
							ret[j].parent = getNodeByName (una + lxbone[i][3])
							exit
						)
					)
				)else if i > 31 then(
					for j = 1 to ret.count do(
						if ret[j].name == una + lxbone[i][2] then (
							ret[j].parent = getNodeByName (una + lxbone[i][5])
							exit
						)
					)
				)
			)
			for i = 1 to ret.count do
			(
				ret[i].transform = tra[i]
			)
			return ret	
		)
		1:(
			ret = #()
			tra = #()
			for i = 1 to lxbone.count do
			(
				bip = getNodeByName (una + lxbone[i][2])
				if bip == undefined then(
					MessageBox("缺少对象：" + (una + lxbone[i][2]) + "！") title:"提示!" beep:false
					return -1
				)
				bon = bone size:0.2 --showLinks:true;
				--bon.boxsize  = [0.8,0.8,0.8]
				bon.name = "bon_" + una + lxbone[i][2];
				bon.transform = bip.transform
				AppEnd ret bon
				append tra bip.transform
			)
			/*连接bone骨骼*/
			for i = 1 to lxbone.count do
			(
				if i < 31 then
				(
					bon = getNodeByName ("bon_" + una + lxbone[i][2])
					bon.parent = getNodeByName ("bon_" + una + lxbone[i][3]);
				)else if i > 31 then(
					bon = getNodeByName ("bon_" + una + lxbone[i][2])
					bon.parent = getNodeByName ("bon_" + una + lxbone[i][5]);
				)
			)
			for i = 1 to ret.count do(
				ret[i].transform = tra[i]
			)
			return ret
		)
	)
	return -1
)
function getmax maxtime chk1 chk2 wpnl wpnr=(--取max动画 时间轴 amb中的id
	bonarr = #()
	bip = false
	for j = 1 to lxbone.count do
	(
		bo = getNodeByName lxbone[j][2]
		if bo == undefined then(
			MessageBox("缺少对象:" + lxbone[j][2] + "\n请使用流星标准骨骼导出！") title:"错误!" beep:false
			return -1 
		)
		if classof bo == Biped_Object then(
			bip = true
			exit
		)
	)
	tmp = #()
	at time maxtime (
		--骨骼 Biped_Object
		if bip then(
			bonarr = newbon "" 1
		)	
		for j = 1 to lxbone.count do (	
			if bip then(
				bo = getNodeByName ("bon_" + lxbone[j][2])
			)else(
				bo = getNodeByName lxbone[j][2]
			)
			if bo == undefined then(
				MessageBox("缺少对象:" + lxbone[j][2] + "\n请使用流星标准骨骼导出！") title:"错误!" beep:false
				return -1 
			)
			--select (bo)
			in coordsys parent		-- 指明在父空间内设置 
			(
				tmp1 = AmbDat()
				pos = bo.pos --平移
				rot = bo.rotation --max是 x,y,z,w
				if j == 1 or j > 30 then
				(
					tmp1.pos[1] = pos.x
					tmp1.pos[2] = pos.y
					tmp1.pos[3] = pos.z
				)
				tmp1.rot[1] = rot.w
				tmp1.rot[2] = rot.x
				tmp1.rot[3] = rot.y
				tmp1.rot[4] = rot.z
				tmp[j] = tmp1
			)
		)
	)
	if chk2 then(
		at time maxtime (
			bo = getNodeByName "自由镜头"
			if bo == undefined then(
				MessageBox("缺少自由镜头！") title:"错误!" beep:false
				return -1 
			)
			if bonarr.count == 0 then (
				bbo = getNodeByName lxbone[1][2]
			)else(
				bbo = getNodeByName ("bon_" + lxbone[1][2])
			)
			in coordsys world
			(
				bpos = bbo.pos --平移
				brot = bbo.rotation --max是 x,y,z,w
				tmpb = Dummy length:0.2 width:0.2 height:0.2;
				tmpb.boxsize  = [0.8,0.8,0.8]
				tmpb.name = "tmpb"
				tmpb.parent = bo
				tmpb.rotation = brot
				tmpb.pos = bpos
				pos = bo.pos --平移
				rot = bo.rotation --max是 x,y,z,w
			)
			in coordsys parent		-- 指明在父空间内设置 
			(
				tmppos = tmpb.pos --平移
				tmprot = tmpb.rotation --max是 x,y,z,w
			)
			--print tmp[31].pos
			--print tmp[1].pos

			tmp[31].pos[1] = pos.x
			tmp[31].pos[2] = pos.y
			tmp[31].pos[3] = pos.z
			tmp[31].rot[1] = rot.w
			tmp[31].rot[2] = rot.x
			tmp[31].rot[3] = rot.y
			tmp[31].rot[4] = rot.z

			tmp[1].pos[1] = tmppos.x
			tmp[1].pos[2] = tmppos.y
			tmp[1].pos[3] = tmppos.z
			tmp[1].rot[1] = tmprot.w
			tmp[1].rot[2] = tmprot.x
			tmp[1].rot[3] = tmprot.y
			tmp[1].rot[4] = tmprot.z

			delete tmpb
		)
	)
	if chk1 then(
		posz = ((tmp[1].pos[3]) as float)-20.0
		if posz < 0 then(
			posz = 0.0
		)
		tmp[31].pos[1] = tmp[1].pos[1]
		tmp[31].pos[2] = tmp[1].pos[2]
		tmp[31].pos[3] = posz
		tmp[1].pos[1] = 0.0
		tmp[1].pos[2] = 0.0
	)
	if wpnl != undefined then(
		at time maxtime (
			if bonarr.count == 0 then (
				wpnlp = getNodeByName lxbone[34][2]
			)else(
				wpnlp = getNodeByName ("bon_" + lxbone[34][2])
			)
			tmpw = Dummy length:0.2 width:0.2 height:0.2;
			tmpw.boxsize  = [0.8,0.8,0.8]
			tmpw.name = "tmpwpnl"
			tmpw.parent = wpnl
			in coordsys parent(
				tmpw.rotation = eulerangles 0 0 0
				tmpw.pos = [0,0,0]
			)
			in coordsys world
			(
				wpos = tmpw.pos --平移
				wrot = tmpw.rotation --max是 x,y,z,w
				tmpw.parent = wpnlp
				tmpw.rotation = wrot
				tmpw.pos = wpos
			)
			in coordsys parent		-- 指明在父空间内设置 
			(
				tmppos = tmpw.pos --平移
				tmprot = tmpw.rotation --max是 x,y,z,w
			)
			tmp[33].pos[1] = tmppos.x
			tmp[33].pos[2] = tmppos.y
			tmp[33].pos[3] = tmppos.z
			tmp[33].rot[1] = tmprot.w
			tmp[33].rot[2] = tmprot.x
			tmp[33].rot[3] = tmprot.y
			tmp[33].rot[4] = tmprot.z

			delete tmpw
		)
	)
	if wpnr != undefined then(
		at time maxtime (
			if bonarr.count == 0 then (
				wpnrp = getNodeByName lxbone[36][2]
			)else(
				wpnrp = getNodeByName ("bon_" + lxbone[36][2])
			)
			tmpw = Dummy length:0.2 width:0.2 height:0.2;
			tmpw.boxsize  = [0.8,0.8,0.8]
			tmpw.name = "tmpwpnr"
			tmpw.parent = wpnr
			in coordsys parent(
				tmpw.rotation = eulerangles 0 0 0
				tmpw.pos = [0,0,0]
			)
			in coordsys world
			(
				wpos = tmpw.pos --平移
				wrot = tmpw.rotation --max是 x,y,z,w
				tmpw.parent = wpnrp
				tmpw.rotation = wrot
				tmpw.pos = wpos
			)
			in coordsys parent		-- 指明在父空间内设置 
			(
				tmppos = tmpw.pos --平移
				tmprot = tmpw.rotation --max是 x,y,z,w
			)
			tmp[35].pos[1] = tmppos.x
			tmp[35].pos[2] = tmppos.y
			tmp[35].pos[3] = tmppos.z
			tmp[35].rot[1] = tmprot.w
			tmp[35].rot[2] = tmprot.x
			tmp[35].rot[3] = tmprot.y
			tmp[35].rot[4] = tmprot.z

			delete tmpw
		)
	)
	if bonarr.count != 0 then (delete bonarr)
	return tmp
)
function setmax val AmbFrames AmbStart MaxStart=(--写动画
	--max set key mode
	bip = false
	for i = 1 to lxbone.count do(
		bo = getNodeByName (lxbone[i][2])
		if classof bo == Biped_Object then(
			bip = true
			exit
		)
	)
	if bip then(
		tmpbon = newbon "" 1
		for i = 1 to AmbFrames do(
			id = i+AmbStart
			--format "正在导入帧：%\n"		id
			animate on(
				at time (i-1+MaxStart)(
					for j = 1 to lxbone.count do(
						bo = getNodeByName ("bon_" + lxbone[j][2])
						--select (bo)
						if j == 1 or j > 30 then(
							px = val[id][j].pos[1]
							py = val[id][j].pos[2]
							pz = val[id][j].pos[3]
							qw = val[id][j].rot[1]
							qx = val[id][j].rot[2]
							qy = val[id][j].rot[3]
							qz = val[id][j].rot[4]
							-- 指明在父空间内设置
							tmppos = [px,py,pz]
							tmprot = quat qx qy qz qw						
							in coordsys parent (
								bo.rotation = tmprot
								bo.pos = tmppos
							)
						)else(
							qw = val[id][j].rot[1]
							qx = val[id][j].rot[2]
							qy = val[id][j].rot[3]
							qz = val[id][j].rot[4]
							-- 指明在父空间内设置
							in coordsys parent (
								tmppos = bo.pos --寄存坐标防止旋转后坐标错乱
								tmprot = quat qx qy qz qw
								bo.rotation = tmprot
								bo.pos = tmppos
							)
						)
					)
					for j = 1 to lxbone.count do(
						bip = getNodeByName lxbone[j][2]
						bon = getNodeByName ("bon_" + lxbone[j][2])
						in coordsys parent (
							bip.transform = bon.transform
						)
					)
				)
			)
		)
		delete tmpbon
	)else(
		for i = 1 to AmbFrames do(
			id = i+AmbStart
			--format "正在导入帧：%\n"		id
			animate on(
				at time (i-1+MaxStart)(
					for j = 1 to lxbone.count do(
						bo = getNodeByName (lxbone[j][2])
						--select (bo)
						if j == 1 or j > 30 then(
							px = val[id][j].pos[1]
							py = val[id][j].pos[2]
							pz = val[id][j].pos[3]
							qw = val[id][j].rot[1]
							qx = val[id][j].rot[2]
							qy = val[id][j].rot[3]
							qz = val[id][j].rot[4]
							-- 指明在父空间内设置 
							in coordsys parent (
								bo.rotation = quat qx qy qz qw
								bo.pos = [px,py,pz]
							)
						)else(
							qw = val[id][j].rot[1]
							qx = val[id][j].rot[2]
							qy = val[id][j].rot[3]
							qz = val[id][j].rot[4]
							-- 指明在父空间内设置
							in coordsys parent (
								pos = bo.pos --寄存坐标防止旋转后坐标错乱
								bo.rotation = quat qx qy qz qw
								bo.pos = pos
							)
						)
					)
				)
			)
		)
	)
	return 1
)
function getamb path=(--取amb
	if path == undefined then (return -1)
	if path == "" then (return -1)
	if doesFileExist  path == False  then (return -1)--查找文件

	ambFile = fopen path "rb"
	--format "AMB路径：%\n"	ambFile
	if ambFile == undefined then (return -1)

	--读入骨骼动画
	fseek ambFile 0 #seek_end
	maxlen = ftell ambFile
	--format "文件长度：%\n"	(maxlen as string)
	if maxlen <= 21 then (
		fclose ambFile
		return -1
	)

	fseek ambFile 0 #seek_set
	Header = ""
	for z = 1 to 5 do
	(
		ch = ReadByte ambFile
		Header = Header + (bit.intAsChar ch)
	)
	--format "头：%\n"	Header
	if Header != "BANIM" then(
		fclose ambFile
		return -1
	)
	Bones = readLong ambFile --骨骼数
	Dummey = readLong ambFile --辅助数
	Frames = readLong ambFile --总帧数
	Frame = readLong ambFile
	--format "帧：%\n"		Frame
	if (maxlen-21)/698 != Frames then (
		fclose ambFile
		return -1
	)
	ret = #()--返回数组
	for i = 1 to Frames do
	(
		tmp = #()
		Unknown = readLong ambFile
		id = readLong ambFile
		for j = 1 to Bones do
		(
			tmp1 = AmbDat()
			if j == 1 then
			(
				tmp1.pos[1] = readFloat ambFile
				tmp1.pos[2] = readFloat ambFile
				tmp1.pos[3] = readFloat ambFile
			)
			tmp1.rot[1] = readFloat ambFile
			tmp1.rot[2] = readFloat ambFile
			tmp1.rot[3] = readFloat ambFile
			tmp1.rot[4] = readFloat ambFile
			append tmp tmp1
		)
		
		for j = (Bones + 1) to (Bones + Dummey) do
		(
			tmp1 = AmbDat()
			DummeyName = ""
			for k = 1 to 5 do
			(
				ch = ReadByte ambFile
				DummeyName = DummeyName + (bit.intAsChar ch)
			)
			--format "文件中辅助节点名：%\n"		DummeyName
			tmp1.pos[1] = readFloat ambFile
			tmp1.pos[2] = readFloat ambFile
			tmp1.pos[3] = readFloat ambFile
			tmp1.rot[1] = readFloat ambFile
			tmp1.rot[2] = readFloat ambFile
			tmp1.rot[3] = readFloat ambFile
			tmp1.rot[4] = readFloat ambFile
			append tmp tmp1
		)
		append ret tmp
	)
	fclose ambFile --关闭文件
	return ret
)
function setamb Val AmbFrames AmbStart MaxStart chk1 chk2 wpnl wpnr id= ( --id: 1/覆盖 2/添加 3/新建 写amb
	if id == 1 and AmbStart > Val.count then(
		MessageBox("覆盖开始帧超出范围!") title:"提示!" beep:false
		return -1 --覆盖开始帧超出范围!
	)
	for j = 1 to lxbone.count do(
		if getNodeByName lxbone[j][2] == undefined then(
			MessageBox("缺少对象:" + lxbone[j][2] + "\n请使用流星标准骨骼导出！") title:"错误!" beep:false
			return -1 
		)
	)
	ret = #()

	case id of (
		1:(--覆盖
			ret = Val
			for i = 1 to AmbFrames do
			(
				ids = i+AmbStart
				tmp = getmax (i-1+MaxStart) chk1 chk2 wpnl wpnr
				if tmp == -1 then(return -1)
				ret[ids] = tmp
			)
		)
		2:(--添加
			ret = Val
			for i = 1 to AmbFrames do
			(
				tmp = getmax (i-1+MaxStart) chk1 chk2 wpnl wpnr
				if tmp == -1 then(return -1)
				append ret tmp
			)
		)
		3:(--新建
			for i = 1 to AmbFrames do
			(
				ids = i-1
				tmp = getmax (ids + MaxStart) chk1 chk2 wpnl wpnr
				if tmp == -1 then(return -1)
				append ret tmp
			)
		)
		default:(
			return -1 --id异常
		)
	)
	return ret
)
function outamb val path=(--生成amb
	ambFile = fopen path "wb" --读rb 写wb
	--format "AMB路径：%\n"	ambFile
	if ambFile == undefined then(return -1)
	for i = 1 to bob.count do
	(
		WriteByte ambFile bob[i]
	)
	--WriteString ambFile "BANIM"
	WriteLong ambFile 30 --骨骼数
	WriteLong ambFile 6 --辅助数
	WriteLong ambFile val.count --帧总数，随帧数变化！
	WriteLong ambFile 30 --动画帧
	for i = 1 to val.count do
	(
		--动画帧开始
		--帧头
		WriteLong ambFile -1 --每帧动画分隔
		WriteLong ambFile (i-1) --动画ID
		for j = 1 to 36 do
		(
			if j == 1 then
			(
				WriteFloat ambFile (val[i][j].pos[1])
				WriteFloat ambFile (val[i][j].pos[2])
				WriteFloat ambFile (val[i][j].pos[3])
				WriteFloat ambFile (val[i][j].rot[1])
				WriteFloat ambFile (val[i][j].rot[2])
				WriteFloat ambFile (val[i][j].rot[3])
				WriteFloat ambFile (val[i][j].rot[4])			
			)else if j <= 30 then
			(
				WriteFloat ambFile (val[i][j].rot[1])
				WriteFloat ambFile (val[i][j].rot[2])
				WriteFloat ambFile (val[i][j].rot[3])
				WriteFloat ambFile (val[i][j].rot[4])			
			)else(
				for k = 1 to dub[j-30].count do
				(
					WriteByte ambFile dub[j-30][k]
				)
				WriteFloat ambFile (val[i][j].pos[1])
				WriteFloat ambFile (val[i][j].pos[2])
				WriteFloat ambFile (val[i][j].pos[3])
				WriteFloat ambFile (val[i][j].rot[1])
				WriteFloat ambFile (val[i][j].rot[2])
				WriteFloat ambFile (val[i][j].rot[3])
				WriteFloat ambFile (val[i][j].rot[4])			
			)
		)
	)
	fclose ambFile --关闭文件
	return 1
)
rollout param0 "文件" width:360 height:170
(
	button 'btn1' "打开文件" pos:[200,100] width:140 height:32 align:#left
    label lab1 "文件：无" pos:[9,13] width:330 height:16
    label lab2 "帧数：0" pos:[9,33] width:330 height:16
    label lab3 "范围：0-0" pos:[9,53] width:330 height:16
    label lab4 "信息：无" pos:[9,73] width:330 height:16

	on btn1 pressed  do(
		Open_name = getOpenFileName types:"流星AMB动作文件 (*.amb)|*.amb|All (*.*)|*.*|" caption:"打开AMB动作"
		if Open_name != undefine then (
			amba = getamb Open_name
			if amba == -1 then(
				lab1.text = "文件：文件异常"
				lab2.text = "帧数：0"
				lab3.text = "范围：0-0"
				lab4.text = "信息：文件打开失败"
			)else(
				lab1.text = "文件：" + Open_name
				lab2.text = "帧数：" + (amba.count as string)
				lab3.text = "范围：0 - " + ((amba.count-1) as string)
				lab4.text = "信息：文件打开成功"
				ambarr = amba
				ambpath = Open_name
			)
			--setmax amba 100 1 0
			--format "数据：%\n"	amba.count
		)

	)
)
rollout param1 "骨骼" width:360 height:170
(
	button 'btn1' "生成biped骨骼" pos:[9,13] width:140 height:32 align:#left
	button 'btn2' "生成bone骨骼" pos:[200,13] width:140 height:32 align:#left
    label titleLabel1 "注：biped骨骼用于制作动作，导入动作需要bone骨骼" pos:[9,60] width:330 height:16
    label titleLabel2 "注：请先关闭“自动关键点”和“设置关键点”" pos:[9,80] width:330 height:16

	on btn1 pressed  do(
		newbip "" 0
	)
	on btn2 pressed  do(
		newbon "" 0
	)
)
rollout param5 "镜头" width:360 height:120
(
	button 'btn1' "生成自由镜头" pos:[14,13] width:320 height:32 align:#left

	on btn1 pressed  do(
		/*
		if getNodeByName "d_base" == undefined then(
			MessageBox("没有标准骨骼！") title:"提示!" beep:false
			return -1
		)
		*/
		if getNodeByName "自由镜头" != undefined then(
			MessageBox("场景中已存在自由镜头！") title:"提示!" beep:false
			return -1
		)
		camera = Freecamera length:0.2 width:0.2 height:0.2;
		camera.name = "自由镜头";
		camera.rotation  = quat 0 -0.608761 -0.793353 0
		camera.pos  = [0,141.732,74.8031]
		RotatePivotOnly camera (quat 0 -0.608761 -0.793353 0)
		camera.pivot = [0,0,0]
		camera.parent = getNodeByName "d_base"
		in coordsys parent (
			camera.rotation  = quat 0 0 0 1
			camera.pos  = [0,0,0]
		)
	)
)
rollout param2 "导入" width:360 height:170
(
	label 'lbl1' "帧范围：" pos:[9,14] width:56 height:25 align:#left
	editText 'edt1' "" text:"0-0" pos:[50,11] width:168 height:18 align:#left
	label 'lbl2' "关键点：" pos:[9,36] width:56 height:25 align:#left
	label 'lbl3' "导入max中的第一帧" pos:[119,36] width:256 height:25 align:#left
	label 'lbl4' "amb中的帧范围" pos:[224,14] width:256 height:21 align:#left
	editText 'edt2' "" text:"0" pos:[50,33] width:64 height:18 align:#left
	checkbox 'chk1' "高精度导入(需要更多时间)" pos:[52,54] width:300 height:20 align:#left checked:false
	button 'btn1' "导入" pos:[248,83] width:96 height:28 align:#left
	
	on btn1 pressed  do(
		if ambarr.count == 0 then(
			MessageBox("请先打开文件！") title:"提示!" beep:false
			return -1
		)
		if edt1.text.count == 0 then(
			MessageBox("请输入帧范围！") title:"提示!" beep:false
			return -1	
		)
		if edt2.text.count == 0 then(
			MessageBox("请输入开始的关键点！") title:"提示!" beep:false
			return -1	
		)
		str = filterString  edt1.text "-"--分割
		if str.count != 2 then(
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		ambs = 0
		ambe = 0
		maxs = 0
		try (
			ambs = str[1] as integer
			ambe = str[2] as integer
		) catch (
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		try (
			maxs = edt2.text as integer
		) catch (
			MessageBox("请输入正确的开始关键点！") title:"提示!" beep:false
			return -1		
		)
		if ambs < 0 or ambe < 0 or maxs < 0 then(
			MessageBox("不能为负数！") title:"提示!" beep:false
			return -1		
		)
		if ambs > ambe then(
			MessageBox("范围开始不能大于结束！") title:"提示!" beep:false
			return -1		
		)
		if ambs >= ambarr.count or ambe >= ambarr.count then(
			MessageBox("导入范围超出了文件范围！\n当前文件范围为：0-" + ((ambarr.count-1) as string)) title:"提示!" beep:false
			return -1		
		)
		bonnum = 0
		for i = 1 to lxbone.count do
		(
			if getNodeByName (lxbone[i][2]) != undefined then(
				bonnum += 1
			)
		)
		setmaxret = -1
		if bonnum == lxbone.count then(
			setmaxret = setmax ambarr (ambe - ambs +1) ambs maxs
			if chk1.checked and setmaxret == 1 then(
				setmaxret = setmax ambarr (ambe - ambs +1) ambs maxs
			)
		)else if bonnum == 0 then(
			if ((queryBox ("没有找到导入骨骼！\n是否生成biped骨骼并继续？")) == false )then (
				return -1
			)else(
				newbip "" 0
				setmaxret = setmax ambarr (ambe - ambs +1) ambs maxs
				if chk1.checked and setmaxret == 1 then(
					setmaxret = setmax ambarr (ambe - ambs +1) ambs maxs
				)	
			)
		)else(
			MessageBox("骨骼异常，请使用标准骨骼！") title:"提示!" beep:false
			return -1		
		)
		if setmaxret == 1 then(
			MessageBox("amb导入成功！") title:"提示!" beep:false
			param0.lab4.text = "信息：导入范围：" + (maxs as string) + " - " + ((ambe - ambs + maxs) as string)
		)else(
			MessageBox("amb导入异常！") title:"提示!" beep:false
			return -1		
		)
	)
)
rollout param3 "导出" width:360 height:180
(
	label 'lbl1' "帧范围：" pos:[9,14] width:56 height:25 align:#left
	editText 'edt1' "" text:"0-0" pos:[50,11] width:168 height:18 align:#left
	label 'lbl2' "关键点：" pos:[9,36] width:56 height:25 align:#left
	label 'lbl3' "amb中的开始点，覆盖时才需要填写" pos:[119,36] width:256 height:25 align:#left
	label 'lbl4' "max中的帧范围" pos:[224,14] width:256 height:21 align:#left
	editText 'edt2' "" text:"0" pos:[50,33] width:64 height:18 align:#left
	label 'lbl5' "左武器：" pos:[9,58] width:56 height:25 align:#left
	label 'lbl6' "右武器：" pos:[180,58] width:56 height:25 align:#left
	editText 'edt3' "" text:"" pos:[50,55] width:110 height:18 align:#left
	editText 'edt4' "" text:"" pos:[221,55] width:110 height:18 align:#left
	checkbox 'chk1' "镜头跟随质心（b骨骼）并且镜头高度不小于零" pos:[53,79] width:300 height:20 align:#left checked:false
	checkbox 'chk2' "使用自由镜头" pos:[53,99] width:300 height:20 align:#left checked:false
	button 'btn1' "覆盖" pos:[85,131] width:79 height:25 align:#left
	button 'btn2' "添加" pos:[175,131] width:79 height:25 align:#left
	button 'btn3' "新建" pos:[265,131] width:79 height:25 align:#left
	on btn1 pressed  do(
		if ambarr.count == 0 or ambpath == undefined then(
			MessageBox("请先打开文件！") title:"提示!" beep:false
			return -1
		)
		if edt1.text.count == 0 then(
			MessageBox("请输入帧范围！") title:"提示!" beep:false
			return -1	
		)
		if edt2.text.count == 0 then(
			MessageBox("请输入覆盖关键点！") title:"提示!" beep:false
			return -1	
		)
		str = filterString  edt1.text "-"--分割
		if str.count != 2 then(
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		maxs = 0
		maxe = 0
		ambs = 0
		try (
			maxs = str[1] as integer
			maxe = str[2] as integer
		) catch (
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		try (
			ambs = edt2.text as integer
		) catch (
			MessageBox("请输入正确的覆盖关键点！") title:"提示!" beep:false
			return -1		
		)
		if ambs < 0 or maxe < 0 or maxs < 0 then(
			MessageBox("不能为负数！") title:"提示!" beep:false
			return -1		
		)
		if maxs > maxe then(
			MessageBox("范围开始不能大于结束！") title:"提示!" beep:false
			return -1		
		)
		if ambs >= ambarr.count then(
			MessageBox("覆盖范围超出了文件范围！\n当前文件范围为：0-" + ((ambarr.count-1) as string)) title:"提示!" beep:false
			return -1		
		)
		wpnl = undefined
		wpnr = undefined
		if edt3.text != "" then(
			if getNodeByName edt3.text == undefined then(
				MessageBox("没有找到指定左手武器 " + edt3.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnl = getNodeByName edt3.text
			)
		)
		if edt4.text != "" then(
			if getNodeByName edt4.text == undefined then(
				MessageBox("没有找到指定右手武器 " + edt4.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnr = getNodeByName edt4.text
			)
		)
		outarr = setamb ambarr (maxe-maxs+1) ambs maxs chk1.checked chk2.checked wpnl wpnr 1
		if outarr != -1 then(
			if outamb outarr ambpath == 1 then(
				MessageBox("文件覆盖成功！") title:"提示!" beep:false
				ambarr = outarr
				param0.lab2.text = "帧数：" + (ambarr.count as string)
				param0.lab3.text = "范围：0 - " + ((ambarr.count-1) as string)
				param0.lab4.text = "信息：覆盖范围：" + ((ambs + maxs) as string) + " - " + ((ambs + maxe) as string)	
			)else(
				MessageBox("文件覆盖失败！") title:"提示!" beep:false
			)
		)
	)
	on btn2 pressed  do(
		if ambarr.count == 0 or ambpath == undefined then(
			MessageBox("请先打开文件！") title:"提示!" beep:false
			return -1
		)
		if edt1.text.count == 0 then(
			MessageBox("请输入帧范围！") title:"提示!" beep:false
			return -1	
		)
		str = filterString  edt1.text "-"--分割
		if str.count != 2 then(
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		maxs = 0
		maxe = 0
		try (
			maxs = str[1] as integer
			maxe = str[2] as integer
		) catch (
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		if maxe < 0 or maxs < 0 then(
			MessageBox("不能为负数！") title:"提示!" beep:false
			return -1		
		)
		if maxs > maxe then(
			MessageBox("范围开始不能大于结束！") title:"提示!" beep:false
			return -1		
		)
		wpnl = undefined
		wpnr = undefined
		if edt3.text != "" then(
			if getNodeByName edt3.text == undefined then(
				MessageBox("没有找到指定左手武器 " + edt3.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnl = getNodeByName edt3.text
			)
		)
		if edt4.text != "" then(
			if getNodeByName edt4.text == undefined then(
				MessageBox("没有找到指定右手武器 " + edt4.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnr = getNodeByName edt4.text
			)
		)
		ambnum = ambarr.count
		outarr = setamb ambarr (maxe-maxs+1) 0 maxs chk1.checked chk2.checked wpnl wpnr 2
		if outarr != -1 then(
			if outamb outarr ambpath == 1 then(
				MessageBox("文件添加成功！") title:"提示!" beep:false
				param0.lab2.text = "帧数：" + (outarr.count as string)
				param0.lab3.text = "范围：0 - " + ((outarr.count-1) as string)
				param0.lab4.text = "信息：添加范围：" + (ambnum as string) + " - " + ((outarr.count-1) as string)	
				ambarr = outarr
			)else(
				MessageBox("文件添加失败！") title:"提示!" beep:false
			)
		)
	)
	on btn3 pressed  do(
		if edt1.text.count == 0 then(
			MessageBox("请输入帧范围！") title:"提示!" beep:false
			return -1	
		)
		str = filterString  edt1.text "-"--分割
		if str.count != 2 then(
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		maxs = 0
		maxe = 0
		try (
			maxs = str[1] as integer
			maxe = str[2] as integer
		) catch (
			MessageBox("请输入正确帧范围格式！\n如：1-9") title:"提示!" beep:false
			return -1		
		)
		if maxs < 0 or maxe < 0 then(
			MessageBox("不能为负数！") title:"提示!" beep:false
			return -1		
		)
		if maxs > maxe then(
			MessageBox("范围开始不能大于结束！") title:"提示!" beep:false
			return -1		
		)
		wpnl = undefined
		wpnr = undefined
		if edt3.text != "" then(
			if getNodeByName edt3.text == undefined then(
				MessageBox("没有找到指定左手武器 " + edt3.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnl = getNodeByName edt3.text
			)
		)
		if edt4.text != "" then(
			if getNodeByName edt4.text == undefined then(
				MessageBox("没有找到指定右手武器 " + edt4.text) title:"提示!" beep:false
				return -1		
			)else(
				wpnr = getNodeByName edt4.text
			)
		)
		outarr = setamb #() (maxe-maxs+1) 0 maxs chk1.checked chk2.checked wpnl wpnr 3
		if outarr != -1 then(
			Save_name = getSaveFileName types:"流星AMB动作文件 (*.amb)|*.amb|All (*.*)|*.*|" caption:"保存AMB动作文件"
			if Save_name == undefined then (
				return -1
			)
			if outamb outarr Save_name == 1 then(
				MessageBox("文件生成成功！") title:"提示!" beep:false
			)else(
				MessageBox("文件生成失败！") title:"提示!" beep:false
			)
		)
	)
)
rollout param4 "关于" width:360 height:270
(
	label titleLabel1 "资料：" pos:[9,10] width:240 height:16
	HyperLink add1 "人物资料表" pos:[180,30] width:160 height:16 address:"https://www.lxres.com/LiuXingBiJi/1554.html" color:(color 94 234 255) hovercolor:(color 255 0 0)
	HyperLink add2 "武器资料表" pos:[19,50] width:160 height:16 address:"https://www.lxres.com/LiuXingBiJi/1557.html" color:(color 94 234 255) hovercolor:(color 255 0 0)
	HyperLink add3 "动作资料表" pos:[19,30] width:160 height:16 address:"https://www.lxres.com/LiuXingBiJi/1758.html" color:(color 94 234 255) hovercolor:(color 255 0 0)
	HyperLink add0 "访问流星资源网 (To Lxres.com)" pos:[9,400] width:240 height:16 address:"www.lxres.com" color:(color 94 234 255) hovercolor:(color 255 0 0)
	label titleLabel3 "by 漠之北" pos:[286,400] width:60 height:16
)
if floater != undefined do
(
closerolloutfloater floater
)
floater = newrolloutfloater "流星AMB导入导出 v0.39(测试版)" 360 440
addrollout param0 floater rolledUp:false
addrollout param1 floater rolledUp:true
addrollout param5 floater rolledUp:true
addrollout param2 floater rolledUp:true
addrollout param3 floater rolledUp:true
addrollout param4 floater rolledUp:true
