﻿------------------------------------------------------
-- fmc&pos动画辅助工具
-- 过山河。
-- 
-- 新增帧数提醒
-- v1.4.1
-- 20250930
-- 
-- 支持自定义骨骼动画
-- 支持负值缩小
-- 修复des重复bug，此bug由于点击了导出前整理button
-- v1.4.0
-- 20250929
--
-- 修复一些小bug
-- v1.3.3
-- 20250923 
--
-- 新增整理置底模型button
-- 新增等比例缩放，修改置底button逻辑
-- v1.3.2
-- 20250922
--
-- 新增快照比例缩放1、1+0.2、1+0.2+0.2....
-- v1.3.1
-- 20250911
--
-- 修改快照间隔设置，增加清空快照
-- 移植小脑斧流星模型导出脚本中的gmb、des、置底模块
-- v1.3.0
-- 20250910
--
-- v1.2.0
-- 20250909
--
-- 支持点缓存等模型动画 
-- 修正帧范围逻辑
-- 整合导出pos和fmc文件逻辑
-- 修改快照后删除原对象逻辑，一键化操作
-- v1.1.0
-- 20250906
-- 
-- v1.0.0
-- 20250801
------------------------------------------------------

try (destroyDialog roSnapshot) catch ()

-- 对象名称排序
fn compareByName a b = 
(
    case of
    (
        (a.name < b.name): -1
        (a.name > b.name): 1
        default: 0
    )
)
-- 字符串转数组并去重
fn StrAsArray str = (
    ret = #()
    tstr = filterString str ","
    for i = 1 to tstr.count do (
        if findItem ret tstr[i] == 0 then (append ret tstr[i])
    )
    return ret
)

-- 反转列表
fn reverseList listText = (
    if listText == "" do return ""
    local items = filterString listText "\n"
    local reversedItems = #()
    for i = items.count to 1 by -1 do (append reversedItems items[i])
    local result = ""
    for item in reversedItems do (result += item + "\n")
    return result
)

-- 检测是否为辅助对象
fn isHelperObject obj = (
    helperTypes = #(
        Dummy, Point, -- 虚拟对象和点
        BoneGeometry, Biped_Object, -- 骨骼和Biped
        TargetObject, CameraTarget, -- 目标对象
        Light, Omnilight, FreeLight, TargetLight, -- 灯光
        SunLight, SkyLight, -- 天光和太阳光
        AssemblyHead, XRefObject, -- 集合头和外部参考
        Grid, Tape, Protractor, Compass, -- 测量工具
        Crowd, Delegate, -- 人群和代理
        VRayLight, VRaySun, VRaySky, -- VRay相关
        Container, -- 容器
        Shape -- 二维图形
    )
    
    -- 按名称模式过滤
    namePatterns = #(
        "*Helper*", "*Dummy*", "*Point*", "*Target*", 
        "*Bone*", "*Bip*", "*Light*", "*Camera*",
        "*虚拟*", "*辅助*", "*参考*", "*$*"
    )
    
    -- 按类型检测
    isHelperByType = false
    for helperType in helperTypes do (
        if classOf obj == helperType then (
            isHelperByType = true
            exit
        )
    )
    
    -- 按名称检测
    isHelperByName = false
    objName = obj.name as string
    for pattern in namePatterns do (
        if matchPattern objName pattern:pattern then (
            isHelperByName = true
            exit
        )
    )
    
    -- 按层级检测
    isHelperByParent = false
    if obj.parent != undefined then (
        parentName = obj.parent.name as string
        for pattern in namePatterns do (
            if matchPattern parentName pattern:pattern then (
                isHelperByParent = true
                exit
            )
        )
    )
    return isHelperByType or isHelperByName or isHelperByParent
)

fn filterHelpers objects = (
    validObjects = #()
    for obj in objects do (
        if not (isHelperObject obj) then (
            -- 检查是否为可导出的几何体
            if (superClassOf obj == GeometryClass) and (canConvertTo obj Mesh) then (
                try (
                    -- 尝试创建网格快照，确保对象有效
                    tmp = snapshotAsMesh obj
                    if tmp.numVerts > 0 then (append validObjects obj)
                    delete tmp
                ) catch (
                    format "跳过无效对象: %\n" obj.name
                )
            )
        ) else (
            format "跳过辅助对象: %\n" obj.name
        )
    )
    return validObjects
)

-- 字符串格式化
fn xs var1 var2 = (
    var = var1 as float
    str = "0."+ var2 as string +"f"
    ret = formattedPrint var format:str
    return ret
)

-- 转换为TGA
fn autoConvertToTGA texPath = (
    if texPath == undefined or texPath == "" or texPath == "NONE" then (return "NONE")
    
    texname = filenameFromPath texPath
    textyp = getFilenameType texPath
    textex = getFilenameFile texPath
    
    convertFormats = #(".dds", ".psd", ".png")
    
    keepFormats = #(".tga", ".jpg", ".bmp")
    
    if findItem convertFormats (toLower textyp) > 0 then (return textex + ".tga")
    else if findItem keepFormats (toLower textyp) > 0 then (return texname)
    else (return textex + ".tga")
)

-- 材质字符串处理
fn matstr obj mat = (
    tex = ""
    
    mtype = classof mat
    case mtype of (
        Standardmaterial:(
            if classof mat.diffuseMap == Bitmaptexture then (tex = mat.diffuseMap.filename)
            else (tex = "NONE")
        )
        PhysicalMaterial:(
            if classof mat.base_color_map == Bitmaptexture then (tex = mat.base_color_map.filename)
            else (tex = "NONE")
        )
        default:(return undefined)
    )
    
    if tex == "" or tex == undefined then (tex = "NONE")
    
    -- 自动转换图片格式
    tex = autoConvertToTGA(tex)
    
    -- 使用默认值
    option = "1"  -- NORMAL
    twoside = "0" -- 非双面
    tblend = "1"  -- DISABLE 1 0
    opacity = "1.0" -- 完全不透明
    
    str = (tex as string) + "|" + option + "|" + twoside + "|" + tblend + "|" + opacity
    return str
)

-- 对象分类
fn outcls obj down = (
    ret = #()
    if obj.count == 0 then (return undefined)
    
    cls1 = #() -- 模型
    cls2 = #() -- 置底对象
    cls8 = #() -- 跳过
    clsd = #()
    
    for i = 1 to obj.count do (
        if (findItem down obj[i].name > 0) then (
            try (
                tmp = snapshotAsMesh obj[i]
                clsd[findItem down obj[i].name] = obj[i]
            ) catch (append cls8 obj[i])
        ) else (
            try (
                tmp = snapshotAsMesh obj[i]
                append cls1 obj[i]
            ) catch (append cls8 obj[i])
        )
    )
    
    for i = 1 to clsd.count do (
        if clsd[i] != undefined then (append cls2 clsd[i])
    )
    
    append ret cls1
    append ret cls2
    append ret #() -- 空数组，保持结构兼容
    append ret #()
    append ret #()
    append ret #()
    append ret #()
    append ret cls8
    return ret
)

-- 提取数字后缀
fn extractNumberSuffix str = 
(
    local digits = ""
    for i = str.count to 1 by -1 do
    (
        if (str[i] >= "0" and str[i] <= "9") then
            digits = str[i] + digits
        else
            exit
    )
    if digits.count > 0 then digits as integer else 0
)

-- 数据结构定义
struct Lx_vers (vv, nv, col, tv)
struct Lx_facs (mid, fac, fnv)
struct Lx_data (_name, vers=#(), facs=#())
struct Lx_ret (mats, dats)

-- 获取模型数据
fn getdat objs = (
    if objs.count == 0 then (return undefined)
    
    lx_mats = #()
    lx_dats = #()
    
    for i = 1 to objs.count do (
        tmpdat = Lx_data()
        tmpobj = snapshotAsMesh objs[i]
        tmpdat._name = objs[i].name
        colnum = getNumCPVVerts tmpobj
        tvvnum = tmpobj.numtverts
        
        if tvvnum == 0 then (
            if ((queryBox ("对象 " + tmpdat._name + " 没有UV纹理，是否导出？")) == false ) then (continue)
        )
        
        mbol = #()
        if classof objs[i].material == Multimaterial then (
            for m = 1 to objs[i].material.numsubs do (mbol[m] = false)
            for j = 1 to tmpobj.numfaces do (
                id = getFaceMatID tmpobj j
                mbol[id] = true
            )
        )
        
        fmid = 0
        fmids = #()
        if classof objs[i].material == Multimaterial then (
            for m = 1 to objs[i].material.numsubs do (
                if mbol[m] then (
                    mat_str = matstr objs[i] objs[i].material.materialList[m]
                    if mat_str == undefined then (fmids[m] = 0)
                    else if findItem lx_mats mat_str == 0 then (
                        append lx_mats mat_str
                        fmids[m] = lx_mats.count
                    ) else (fmids[m] = findItem lx_mats mat_str)
                )
            )
        ) else (
            mat_str = matstr objs[i] objs[i].material
            if mat_str == undefined then (fmid = 0)
            else if findItem lx_mats mat_str == 0 then (
                append lx_mats mat_str
                fmid = lx_mats.count
            ) else (fmid = findItem lx_mats mat_str)
        )
        
        for j = 1 to tmpobj.numfaces do (
            if classof objs[i].material == Multimaterial then (
                id = getFaceMatID tmpobj j
                if fmids[id] == undefined then (fmid = 0) else (fmid = fmids[id])
            )
            
            tmpfac = Lx_facs()
            tmpfac.mid = fmid
            fid = getFace tmpobj j
            if tvvnum == 0 then (tvf = fid) else (tvf = getTVFace tmpobj j)
            
            tmpfac.fac = tvf
            tmpfac.fnv = getFaceNormal tmpobj j
            
            for k = 1 to fid.count do (
                tmpver = Lx_vers()
                tmpver.vv = getVert tmpobj fid[k]
                tmpver.nv = getNormal tmpobj fid[k]
                
                if colnum == 0 then (tmpver.col = Color 255 255 255)
                else (
                    cid = getVCFace tmpobj j
                    tmpver.col = getVertColor tmpobj cid[k]
                )
                
                if tvvnum == 0 then (tmpver.tv = [0.0,1.0,0.0])
                else (tmpver.tv = getTVert tmpobj tvf[k])
                
                tmpdat.vers[tvf[k]] = tmpver
            )
            append tmpdat.facs tmpfac
        )
        append lx_dats tmpdat
    )
    
    ret = Lx_ret()
    ret.mats = lx_mats
    ret.dats = lx_dats
    return ret
)

-- 字符串长度
fn strlen str = (
    len = 1
    for i = 1 to str.count do (
        charint = bit.charAsInt str[i]
        if charint > 65535 then (len += 3)
        else if charint > 255 then (len += 2)
        else (len += 1)
    )
    return len
)

-- 导出GMB
fn togmb dat path = (
    -- GMB文件头
    tuo = #(71,77,68,76,32,86,49,46,48,48) -- GMDL V1.00
    GmbFile = fopen path "wb"
    if GmbFile == undefined then (return false)
    
    for i = 1 to tuo.count do (WriteByte GmbFile tuo[i])
    
    -- 处理材质和贴图
    mats = dat.mats
    texs = #()
    for i = 1 to mats.count do (
        tstr = filterString mats[i] "|"
        if findItem texs tstr[1] == 0 then (append texs tstr[1])
    )
    
    WriteLong GmbFile texs.count -- 贴图数量
    
    for i = 1 to texs.count do (
        if texs[i] == "" or texs[i] == "NONE" then (
            WriteLong GmbFile (strlen "NONE")
            WriteString GmbFile "NONE"
        ) else (
            WriteLong GmbFile (strlen texs[i])
            WriteString GmbFile texs[i]
        )
    )
    
    -- 写入材质信息
    WriteLong GmbFile mats.count
    Textureval = "NORMAL"
    blendval = "DISABLE 1 0"
    
    for i = 1 to mats.count do (
        tstr = filterString mats[i] "|"
        texid = (findItem texs tstr[1])-1
        WriteLong GmbFile texid
        WriteLong GmbFile (strlen Textureval)
        WriteString GmbFile Textureval
        WriteByte GmbFile (tstr[3] as integer)
        WriteLong GmbFile (strlen blendval)
        WriteString GmbFile blendval
        WriteFloat GmbFile (tstr[5] as float)
    )
    
    -- 写入模型数据
    dats = dat.dats
    WriteLong GmbFile dats.count
    WriteLong GmbFile 0
    allvv = 0
    allfac = 0
    for i = 1 to dats.count do (
        allvv += dats[i].vers.count
        allfac += dats[i].facs.count
    )
    
    WriteLong GmbFile allvv
    WriteLong GmbFile allfac
    
    for i = 1 to dats.count do (
        WriteLong GmbFile (strlen dats[i]._name)
        WriteString GmbFile dats[i]._name
        WriteLong GmbFile dats[i].vers.count
        WriteLong GmbFile dats[i].facs.count
        
        for j = 1 to dats[i].vers.count do (
            if dats[i].vers[j] == undefined then (
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
                WriteByte GmbFile 0
                WriteByte GmbFile 0
                WriteByte GmbFile 0
                WriteByte GmbFile 0
                WriteFloat GmbFile 0.0
                WriteFloat GmbFile 0.0
            ) else (
                WriteFloat GmbFile dats[i].vers[j].vv.x
                WriteFloat GmbFile dats[i].vers[j].vv.y
                WriteFloat GmbFile dats[i].vers[j].vv.z
                WriteFloat GmbFile dats[i].vers[j].nv.x
                WriteFloat GmbFile dats[i].vers[j].nv.y
                WriteFloat GmbFile dats[i].vers[j].nv.z
                WriteByte GmbFile (dats[i].vers[j].col.red as integer)
                WriteByte GmbFile (dats[i].vers[j].col.green as integer)
                WriteByte GmbFile (dats[i].vers[j].col.blue as integer)
                WriteByte GmbFile (dats[i].vers[j].col.alpha as integer)
                WriteFloat GmbFile dats[i].vers[j].tv.x
                WriteFloat GmbFile dats[i].vers[j].tv.y
            )
        )
        
        for j = 1 to dats[i].facs.count do (
            WriteLong GmbFile (dats[i].facs[j].mid as integer-1)
            WriteLong GmbFile (dats[i].facs[j].fac[1] as integer-1)
            WriteLong GmbFile (dats[i].facs[j].fac[2] as integer-1)
            WriteLong GmbFile (dats[i].facs[j].fac[3] as integer-1)
            WriteFloat GmbFile dats[i].facs[j].fnv.x
            WriteFloat GmbFile dats[i].facs[j].fnv.y
            WriteFloat GmbFile dats[i].facs[j].fnv.z
        )
    )
    
    fclose GmbFile
    return true
)

-- 导出DES
fn todes obj path = (
    _txt = stringstream ""
    
    -- 计算总对象数量
    local totalObjects = obj[1].count + obj[2].count
    format "# GModel Geometry File V1.0\n" to:_txt    
    format "# Model For Lxres.com Creation Time %\n" LocalTime to:_txt
    format "SceneObjects % DummeyObjects %\n" totalObjects 0 to:_txt
    
    -- 如果所有对象都在置底数组中，只处理置底对象
    local objectsToProcess = if obj[1].count == 0 then obj[2] else obj[1]
    local isAllBottom = (obj[1].count == 0)
    
    -- 写入对象
    for i = 1 to objectsToProcess.count do (
        format "Object %\n" objectsToProcess[i].name to:_txt
        format "{\n" to:_txt
        posx = xs objectsToProcess[i].pos.x 5
        posy = xs objectsToProcess[i].pos.y 5
        posz = xs objectsToProcess[i].pos.z 5
        rotx = xs objectsToProcess[i].rotation.x 5
        roty = xs objectsToProcess[i].rotation.y 5
        rotz = xs objectsToProcess[i].rotation.z 5
        rotw = xs objectsToProcess[i].rotation.w 5
        format "  Position: % % %\n" posx posy posz to:_txt
        format "  Quaternion: % % % %\n" rotw rotx roty rotz to:_txt
        format "  TextureAnimation: 0 0.0 0.0\n" to:_txt
        format "  Custom:\n" to:_txt
        format "  {\n" to:_txt
        format "  }\n" to:_txt
        format "}\n" to:_txt
    )
    
    -- 当不是所有对象都是置底时
    if not isAllBottom and obj[2].count > 0 then (
        for i = 1 to obj[2].count do (
            format "Object %\n" obj[2][i].name to:_txt
            format "{\n" to:_txt
            posx = xs obj[2][i].pos.x 5
            posy = xs obj[2][i].pos.y 5
            posz = xs obj[2][i].pos.z 5
            rotx = xs obj[2][i].rotation.x 5
            roty = xs obj[2][i].rotation.y 5
            rotz = xs obj[2][i].rotation.z 5
            rotw = xs obj[2][i].rotation.w 5
            format "  Position: % % %\n" posx posy posz to:_txt
            format "  Quaternion: % % % %\n" rotw rotx roty rotz to:_txt
            format "  TextureAnimation: 0 0.0 0.0\n" to:_txt
            format "  Custom:\n" to:_txt
            format "  {\n" to:_txt
            format "  }\n" to:_txt
            format "}\n" to:_txt
        )
    )
    
    -- 尝试写入文件
    try (
        out_file = createfile path
        format "%" (_txt as string) to:out_file
        close out_file
        return true
    ) catch (
        return false
    )
)

rollout roSnapshot "fmc&pos动画辅助工具" width:360 height:517
(
    group "快照设置"
    (
        radiobuttons rdoInterval labels:#("逐帧", "隔一帧", "隔两帧") default:1 columns:3 offset:[0,5] tooltip:"勾选合适模式"
        checkbox chkSelected "仅选中的对象" checked:true tooltip:"不勾选则对场景所有对象操作" offset:[0,5] 
        checkbox chkFreezeOriginal "快照后冻结原对象" checked:true tooltip:"冻结所有非快照对象" offset:[0,5]
        edittext edtScaleIncrement "缩放增量:" text:"0.0" fieldWidth:70 align:#right offset:[0,-42] tooltip:"每帧缩放增量(1.0=100%)"
		spinner spnScaleFactor "等比缩放:" range:[-100.0,100.0,1.0] type:#float scale:0.01 fieldWidth:62 align:#right offset:[0,2] tooltip:"正值放大，负值缩小，0=无缩放"
    )
    
    group "帧数范围"
    (
        slider sldRange "" range:[0,100,0] width:340 height:30 ticks:10 offset:[0,5] tooltip:"打开文件后，拖动一下滑块可以刷新关键帧范围"
        label lblStart "开始: 0" align:#left across:2 offset:[0,0]
        label lblEnd "结束: 100" align:#right offset:[-200,0]
		-- 总帧数
		label lblTotalFrames "总帧: 100" align:#right offset:[0,-17] tooltip:"这个数值默认等于帧范围，如果快照设置选择非逐帧，则按相应规则减去"
    )
    
    group "命名规则"
    (
        edittext edtPrefix "" text:"SN_" fieldWidth:330 tooltip:"设定快照后模型的名字前缀"
    )
    
    group "导出设置"
    (
        checkbox chkCreateSnapshot "创建快照" checked:true align:#left across:2 tooltip:"勾选则创建快照，不勾选则直接导出当前模型"
        editText edtZValue "Z轴偏移值:" fieldWidth:70 text:"-100.0" align:#right offset:[0,0] tooltip:"此处一般不做修改，模型比较大时导致穿模可以修改为-200"
        
        checkbox chkExportFmc "导出.fmc" checked:true align:#left offset:[0,0]
        checkbox chkExportPos "导出.pos" checked:true align:#left offset:[87,-18]
		checkbox chkExportGmb "导出.gmb" checked:true align:#left offset:[174,-18]
		checkbox chkExportDes "导出.des" checked:true align:#left offset:[261,-18]
    )
    
    group "导出进度"
    (
        progressBar pbProgress width:335 height:5 align:#center offset:[0,5] tooltip:"点击导出，不要移动鼠标哦，特别是超大文件导出！"
        label lblProgressText "" align:#center offset:[0,2]
    )
    
    button btnAction "生成快照" width:164 height:40 align:#left across:2
    button btnClearSnapshots "清空快照" width:164 height:40 align:#right tooltip:"删除所有快照对象并解冻原对象"
	button btnBottomSettings "|" width:11 height:25 align:#right tooltip:"打开置底设置窗口"
	button btnAutoSetup "导出前整理" width:318 height:25 align:#left offset:[0, -30] toolTip:"将所有选中模型按数字后缀排序并设置为置底" 
    
    label lblStatus "" align:#left offset:[0,-2]
    
    group "版本更新"
    (
        label lblVersion "fmc动画辅助工具 Ver 1.4.1" align:#center offset:[0,5]
        hyperlink hlUpdate "更多工具请访问流星资源网" address:"www.lxres.com" align:#center offset:[0,5] color:(color 94 234 255) hovercolor:(color 255 0 0)
    )
    
    button btnHelp "?" width:20 height:20 align:#right offset:[5,-60] toolTip:"点击查看使用说明"
    
    rollout roHelp "使用说明" width:380 height:300
    (
        label lblHelp1 "1. 仅支持带动画的模型（关键帧、骨骼、点缓存等）" align:#left offset:[10,10]
        label lblHelp2 "2. 静态模型无法生成快照" align:#left offset:[10,0]
        label lblHelp3 "3. 快照对象会自动排除，防止重复生成" align:#left offset:[10,0]
        label lblHelp4 "4. 加载单独的动画模型，任意模型动画" align:#left offset:[10,0]
        label lblHelp5 "5. 选择需要的快照模式，默认逐帧" align:#left offset:[10,0]
        label lblHelp6 "6. 拖动帧范围滑块，脚本会自动刷新帧长度" align:#left offset:[10,0]
        label lblHelp7 "7. 取好名字（自定义）" align:#left offset:[10,0]
        label lblHelp8 "8. 勾选快照仅生成快照，不勾选仅导出其他文件" align:#left offset:[10,0]
        label lblHelp9 "9. z轴偏移值一般不用改动！" align:#left offset:[10,0]
		label lblHelp10 "10. 置底如获取的值不是顺序排列，如1234..，动画会错乱" align:#left offset:[10,0]
		label lblHelp11 "11. 等比缩放和缩放增量可以叠加，优先基础缩放" align:#left offset:[10,0]
		label lblHelp12 "12. 导出前整理按钮是为了数字排列，目前作为手动可选" align:#left offset:[10,0]
	
        
        label lblNoteTitle "注意事项：" align:#left offset:[10,15] font:(dotNetObject "System.Drawing.Font" "Microsoft YaHei" 10 (dotNetClass "System.Drawing.FontStyle").Bold)
        label lblNote1 "- 点缓存动画需先加载才能检测" align:#left offset:[20,0]
        label lblNote2 "- 复杂场景检测可能需要几秒钟" align:#left offset:[20,0]
    )
	
	rollout zhidi "置底设置" width:360 height:270 (
    Edittext text1 "" text:"" pos:[9,32] width:330 height:190
    label titleLabel1 "置底对象：" pos:[9,12] width:320 height:16
    button 'btn1' "当前选择" pos:[265,230] width:79 height:25 align:#left
    button 'btn2' "末尾添加" pos:[175,230] width:79 height:25 align:#left
    button 'btn3' "清空" pos:[85,230] width:79 height:25 align:#left
    button 'btnReverse' "反转" pos:[9,230] width:63 height:25 align:#left
    timer 'tmr1' "Timer" pos:[16,206] width:24 height:24 enabled:true interval:500 active:true align:#left
    
    on tmr1 tick do (
        if getnodebyname "置底设置" == undefined then (text1.text = "")
    )
    on zhidi open do 
(
    obj = getnodebyname "置底设置"
    if obj != undefined then 
    (
        _Down = getUserProp obj "Down"
        if _Down != undefined then 
        (
            -- 获取并排序字符串
            local downArray = StrAsArray _Down
            if downArray.count > 0 then
            (
                fn compareNames a b = 
                (
                    case of
                    (
                        (a < b): -1
                        (a > b): 1
                        default: 0
                    )
                )
                
                qsort downArray compareNames
                
                -- 构建排序后的文本
                local sortedText = stringstream ""
                for i = 1 to downArray.count do (format "%\n" downArray[i] to:sortedText)
                text1.text = sortedText as string
            )
            else
            (
                text1.text = ""
            )
        )
        else
        (
            text1.text = ""
        )
    )
    else
    (
        text1.text = ""
    )
)
    
    on text1 changed text do (
        obj = getnodebyname "置底设置"
        if obj != undefined then (
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp obj "Down" str
        ) else (
            Du = Dummy length:0.1 width:0.1 height:0.1
            Du.name = "置底设置"
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp Du "Down" str
        )
    )
    
    on btn1 pressed do (
        out = getCurrentSelection()
        _txt = stringstream ""
        for i = 1 to out.count do (format "%\n" out[i].name to:_txt)
        text1.text = _txt as string
        obj = getnodebyname "置底设置"
        if obj != undefined then (
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp obj "Down" str
        ) else (
            Du = Dummy length:0.1 width:0.1 height:0.1
            Du.name = "置底设置"
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp Du "Down" str
        )
    )
    
    on btn2 pressed do (
        out = getCurrentSelection()
        _txt = stringstream ""
        for i = 1 to out.count do (format "%\n" out[i].name to:_txt)
        text1.text += _txt as string
        obj = getnodebyname "置底设置"
        if obj != undefined then (
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp obj "Down" str
        ) else (
            Du = Dummy length:0.1 width:0.1 height:0.1
            Du.name = "置底设置"
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp Du "Down" str
        )
    )
    
    on btn3 pressed do (
        text1.text = ""
        obj = getnodebyname "置底设置"
        if obj != undefined then (
            setUserProp obj "Down" "\n"
            delete obj
        )
    )
    
    on btnReverse pressed do (
        text1.text = reverseList text1.text
        obj = getnodebyname "置底设置"
        if obj != undefined then (
            str = ""
            strs = filterString text1.text "\n"
            for i = 1 to strs.count do (str += strs[i] + ",")
            setUserProp obj "Down" str
        )
    )
)
    fn updateProgress percent text = 
    (
        pbProgress.value = percent
        lblProgressText.text = text
        redrawViews()
    )

    fn exportAllFiles objs = 
(
    local exportObjs = for obj in objs where not obj.isFrozen collect obj
    
    if exportObjs.count == 0 then
    (
        lblStatus.text = "没有可导出的未冻结对象！"
        redrawViews()
        return false
    )
    
    local savePath = getSaveFileName \
        caption:"保存文件" \
        filename:(getDir #export + "\\model_export.fmc") \
        types:"FMC文件(*.fmc)|*.fmc|所有文件(*.*)|*.*|"
    
    if savePath == undefined then return false
    
    local basePath = getFilenamePath savePath
    local baseName = getFilenameFile savePath
    
    updateProgress 0 "开始导出文件..."
    redrawViews()
    
    local exportFmc = chkExportFmc.checked
    local exportPos = chkExportPos.checked
    local exportGmb = chkExportGmb.checked
    local exportDes = chkExportDes.checked
    
    local progressIncrement = 25.0
    local currentProgress = 0.0
    
    if exportFmc then
    (
        lblStatus.text = "正在导出FMC文件..."
        redrawViews()
        
        local zValue = try(edtZValue.text as float)catch(0.0)
        qsort exportObjs compareByName
        local totalFrames = exportObjs.count
        
        local fmcPath = basePath + baseName + ".fmc"
        local originalPositions = #()
        for obj in exportObjs do append originalPositions [obj.pos.x, obj.pos.y, obj.pos.z]
        
        updateProgress currentProgress "正在准备FMC导出数据..."
        redrawViews()
        
        local fmcFile
        
        try
        (
            fmcFile = createFile fmcPath
            if fmcFile == undefined then throw "FMC文件创建失败"
            
            format "# GModel Animation File V1.0\n" to:fmcFile
            format "# 这一行留空,不能删除\n" to:fmcFile
            format "SceneObjects % DummeyObjects 0\n" totalFrames to:fmcFile
            format "FPS 60 Frames % Mode: RIGID\n" totalFrames to:fmcFile
            
            for f = 0 to (totalFrames-1) do
            (
                format "frame %\n{\n" f to:fmcFile
                
                for i = 1 to totalFrames do
                (
                    local obj = exportObjs[i]
                    local originalPos = originalPositions[i]
                    local useZ = if (i-1) == f then originalPos.z else zValue
                    local currentPos = [originalPos.x, originalPos.y, useZ]
                    
                    local rot = obj.rotation as quat
                    
                    format " t % % %  q % % % %\n" \
                        currentPos.x currentPos.y currentPos.z \
                        rot.w rot.x rot.y rot.z to:fmcFile
                )
                
                format "}\n" to:fmcFile
                
                local frameProgress = (f/(totalFrames-1)*progressIncrement)
                updateProgress (currentProgress + frameProgress) ("正在导出FMC: " + ((frameProgress/progressIncrement*100) as integer) as string + "%")
                
                redrawViews()
                windows.processPostedMessages()
            )
            
            close fmcFile
            currentProgress += progressIncrement
            updateProgress currentProgress "FMC导出完成!"
            redrawViews()
        )
        catch
        (
            lblStatus.text = "FMC导出失败!"
            updateProgress currentProgress "FMC导出失败!"
            redrawViews()
            
            if fmcFile != undefined then try(close fmcFile)catch()
            return false
        )
    )
    else
    (
        currentProgress += progressIncrement
    )
    
    if exportPos then
    (
        lblStatus.text = "正在导出POS文件..."
        redrawViews()
        
        local zValue = try(edtZValue.text as float)catch(0.0)
        qsort exportObjs compareByName
        local totalFrames = exportObjs.count
        
        local posPath = basePath + baseName + ".pos"
        local originalPositions = #()
        for obj in exportObjs do append originalPositions [obj.pos.x, obj.pos.y, obj.pos.z]
        
        updateProgress currentProgress "正在准备POS导出数据..."
        redrawViews()
        
        local posFile
        
        try
        (
            posFile = createFile posPath
            if posFile == undefined then throw "POS文件创建失败"
            
            for f = 0 to (totalFrames-1) do
            (
                format "pose\n{\n" to:posFile
                format "  start %\n" f to:posFile
                format "  end   %\n" f to:posFile
                format "}\n" to:posFile
                
                local frameProgress = (f/(totalFrames-1)*progressIncrement)
                updateProgress (currentProgress + frameProgress) ("正在导出POS: " + ((frameProgress/progressIncrement*100) as integer) as string + "%")
                
                redrawViews()
                windows.processPostedMessages()
            )
            
            close posFile
            currentProgress += progressIncrement
            updateProgress currentProgress "POS导出完成!"
            redrawViews()
        )
        catch
        (
            lblStatus.text = "POS导出失败!"
            updateProgress currentProgress "POS导出失败!"
            redrawViews()
            
            if posFile != undefined then try(close posFile)catch()
            return false
        )
    )
    else
    (
        currentProgress += progressIncrement
    )
    
    if exportGmb then
    (
        updateProgress currentProgress "正在导出GMB文件..."
        redrawViews()
        
        -- 过滤辅助对象
        local filteredObjects = filterHelpers objs
        if filteredObjects.count == 0 then
        (
            lblStatus.text = "没有找到可导出的几何体对象!"
            currentProgress += progressIncrement
            updateProgress currentProgress "GMB导出跳过!"
            redrawViews()
        )
        else
        (
            -- 获取置底设置
            local down = #()
            local downdu = getnodebyname "置底设置"
            if downdu != undefined then
            (
                local dostr = getUserProp downdu "Down"
                if dostr != undefined then (down = StrAsArray (dostr as string))
            )
            
            local _obj = outcls filteredObjects down
            
            if _obj != undefined then
            (
                local objectsToExport = #()
                for obj in _obj[1] do append objectsToExport obj
                for obj in _obj[2] do append objectsToExport obj
                
                if objectsToExport.count == 0 then
                (
                    lblStatus.text = "没有可导出的模型对象!"
                    currentProgress += progressIncrement
                    updateProgress currentProgress "GMB导出跳过!"
                    redrawViews()
                )
                else
                (
                    local gmbPath = basePath + baseName + ".gmb"
                    local _dat = getdat objectsToExport
                    if _dat != undefined then
                    (
                        if togmb _dat gmbPath then
                        (
                            lblStatus.text = lblStatus.text + " | GMB导出成功"
                            currentProgress += progressIncrement
                            updateProgress currentProgress "GMB导出完成!"
                            redrawViews()
                        )
                        else
                        (
                            lblStatus.text = lblStatus.text + " | GMB导出失败"
                            currentProgress += progressIncrement
                            updateProgress currentProgress "GMB导出失败!"
                            redrawViews()
                        )
                    )
                    else
                    (
                        currentProgress += progressIncrement
                        updateProgress currentProgress "GMB数据准备失败!"
                        redrawViews()
                    )
                )
            )
            else
            (
                currentProgress += progressIncrement
                updateProgress currentProgress "GMB导出跳过!"
                redrawViews()
            )
        )
    )
    else
    (
        currentProgress += progressIncrement
    )
    if exportDes then
    (
        updateProgress currentProgress "正在导出DES文件..."
        redrawViews()
        
        -- 过滤辅助对象
        local filteredObjects = filterHelpers objs
        if filteredObjects.count == 0 then
        (
            lblStatus.text = "没有找到可导出的几何体对象!"
            currentProgress += progressIncrement
            updateProgress currentProgress "DES导出跳过!"
            redrawViews()
        )
        else
        (
            -- 获取置底设置
            local down = #()
            local downdu = getnodebyname "置底设置"
            if downdu != undefined then
            (
                local dostr = getUserProp downdu "Down"
                if dostr != undefined then (down = StrAsArray (dostr as string))
            )
            
            local _obj = outcls filteredObjects down
            
            if _obj != undefined then
            (
                local objectsToExport = #()
                for obj in _obj[1] do append objectsToExport obj
                for obj in _obj[2] do append objectsToExport obj
                
                if objectsToExport.count == 0 then
                (
                    lblStatus.text = "没有可导出的模型对象!"
                    currentProgress += progressIncrement
                    updateProgress currentProgress "DES导出跳过!"
                    redrawViews()
                )
                else
                (
                    local desPath = basePath + baseName + ".des"
                    
                    local desObjects = #(#(), #()) -- 普通模型, 置底对象
                    
                    -- 将所有对象都放到置底对象数组中（obj[2]）
                    for obj in objectsToExport do append desObjects[2] obj
                    
                    if todes desObjects desPath then
                    (
                        lblStatus.text = lblStatus.text + " | DES导出成功"
                        currentProgress += progressIncrement
                        updateProgress currentProgress "DES导出完成!"
                        redrawViews()
                    )
                    else
                    (
                        lblStatus.text = lblStatus.text + " | DES导出失败"
                        currentProgress += progressIncrement
                        updateProgress currentProgress "DES导出失败!"
                        redrawViews()
                    )
                )
            )
            else
            (
                currentProgress += progressIncrement
                updateProgress currentProgress "DES导出跳过!"
                redrawViews()
            )
        )
    )
    else
    (
        currentProgress += progressIncrement
    )
    
    updateProgress 100 "所有文件导出完成!"
    lblStatus.text = ""
    redrawViews()
    
    return true
)

    fn clearSnapshots = 
(
    local prefix = edtPrefix.text
    local snapshots = for obj in objects where matchPattern obj.name pattern:(prefix + "*") collect obj
    
    if snapshots.count > 0 do
    (
        updateProgress 0 "正在清空快照..."
        redrawViews()
        
        undo "Clear Snapshots" on
        (
            try
            (
                if snapshots.count > 0 do 
                (
                    updateProgress 30 "正在删除快照对象..."
                    redrawViews()
                    delete snapshots
                )
                
                -- 解冻和显示所有非快照对象（恢复原始模型、辅助对象等）
                updateProgress 70 "正在解冻和显示所有非快照对象..."
                redrawViews()
                for obj in objects where not (matchPattern obj.name pattern:(prefix + "*")) do 
                (
                    obj.isFrozen = false
                    obj.isHidden = false
                )
                
                updateProgress 100 "清空完成!"
                lblStatus.text = "已清空" + snapshots.count as string + "个快照并解冻显示所有非快照对象"
                redrawViews()
            )
            catch
            (
                updateProgress 0 "清空快照时出错!"
                lblStatus.text = "清空快照时出错!"
                redrawViews()
            )
        )
    )
)

    fn hasAnimationData obj = 
(
    if isProperty obj #controller and obj.controller != undefined and numKeys obj.controller > 0 do return true
    
    if classOf obj == BoneGeometry then
    (
        if isProperty obj #controller and obj.controller != undefined and numKeys obj.controller > 0 do return true
    )
    
    if classOf obj == Biped_Object then
    (
        if isProperty obj #controller and obj.controller != undefined and numKeys obj.controller > 0 do return true
    )
    
    for m in obj.modifiers do
    (
        case (classof m) of
        (
            Skin: 
            (
                try 
                (
                    local bones = #()
                    local boneCount = skinOps.GetNumberBones m
                    if boneCount > 0 do
                    (
                        for i = 1 to boneCount do
                        (
                            local boneName = skinOps.GetBoneName m i 0
                            if boneName != undefined do
                            (
                                local bone = getNodeByName boneName
                                if bone != undefined then
                                (
                                    if isProperty bone #controller and bone.controller != undefined and numKeys bone.controller > 0 do 
                                    (
                                        format "检测到蒙皮骨骼动画: % -> %\n" obj.name bone.name
                                        return true
                                    )
                                    
                                    if classOf bone == Biped_Object then
                                    (
                                        if isProperty bone #controller and bone.controller != undefined and numKeys bone.controller > 0 do 
                                        (
                                            format "检测到Biped骨骼动画: % -> %\n" obj.name bone.name
                                            return true
                                        )
                                    )
                                )
                            )
                        )
                    )
                ) 
                catch ()
            )
            Morpher: (try (if isProperty m #controller and m.controller != undefined and numKeys m.controller > 0 do return true) catch ())
            Flex: (try (if isProperty m #controller and m.controller != undefined and numKeys m.controller > 0 do return true) catch ())
            Cloth: (try (if isProperty m #controller and m.controller != undefined and numKeys m.controller > 0 do return true) catch ())
            Point_Cache: (try (if m.enabled do return true) catch ())
            default: ()
        )
    )
    
    try 
    (
        if obj.material != undefined and isProperty obj.material #controller and obj.material.controller != undefined and numKeys obj.material.controller > 0 do return true
    ) 
    catch ()
    
    for child in obj.children where hasAnimationData child do return true
    
    false
)

    fn isSnapshotObject obj prefix = 
    (
        matchPattern obj.name pattern:(prefix + "??")
    )

    fn getSceneAnimationRange = 
    (
        [animationRange.start.frame as integer, animationRange.end.frame as integer]
    )
	
    fn getKeyframeRange = 
    (
        local allKeys = #()
        local objs = objects
        
        for obj in objs where not obj.isHidden do
        (
            try (join allKeys (getKeyTimes obj.controller)) catch ()
        )
        
        if allKeys.count > 0 then
        (
            local minKey = amin allKeys
            local maxKey = amax allKeys
            return [minKey.frame as integer, maxKey.frame as integer]
        )
        else
        (
            return getSceneAnimationRange()
        )
    )
    
	-- 根据间隔计算总帧数
    fn updateTotalFrames = 
    (
        local startFrame = sldRange.value as integer
        local endFrame = sldRange.range.y as integer

        local interval = case rdoInterval.state of
        (
            1: 1  -- 逐帧
            2: 2  -- 隔一帧
            3: 3  -- 隔两帧
        )
        
        local totalFrames = (endFrame - startFrame) / interval + 1
        
        lblTotalFrames.text = "总帧数: " + (totalFrames as integer) as string
    )
	
    fn updateFrameRange = 
    (
        local range = getKeyframeRange()
        local sceneRange = getSceneAnimationRange()
        
        local actualStart = (amin #(range.x, sceneRange.x)) as integer
        local actualEnd = (amax #(range.y, sceneRange.y)) as integer
        
        sldRange.range = [actualStart as float, actualEnd as float, sldRange.value as float]
        lblStart.text = "开始: " + (sldRange.value as integer) as string
        lblEnd.text = "结束: " + actualEnd as string
        
        updateTotalFrames()
        
        return [actualStart, actualEnd]
    )
	

	
	-- 是否有蒙皮修改器
	fn hasSkinModifier obj =
	(
		for m in obj.modifiers do
		(
			if classOf m == Skin then return true
		)
		false
	)
	
	fn isBoneObject obj =
(
    local boneTypes = #(BoneGeometry, Biped_Object)
    for boneType in boneTypes where classOf obj == boneType do return true
    false
)
-- 蒙皮骨骼是否有动画
fn hasSkinBoneAnimation obj =
(
    for m in obj.modifiers do
    (
        if classOf m == Skin then
        (
            try 
            (
                local boneCount = skinOps.GetNumberBones m
                if boneCount > 0 do
                (
                    for i = 1 to boneCount do
                    (
                        local boneName = skinOps.GetBoneName m i 0
                        if boneName != undefined do
                        (
                            local bone = getNodeByName boneName
                            if bone != undefined and isProperty bone #controller and bone.controller != undefined and numKeys bone.controller > 0 do 
                            (
                                return true
                            )
                        )
                    )
                )
            ) 
            catch ()
        )
    )
    false
)
	-- 等比缩放
    -- 20250922
    fn createSnapshots = 
(
    lblStatus.text = "检测动画类型..."
    redrawViews()
    
    local interval = case rdoInterval.state of
    (
        1: 1
        2: 2
        3: 3
    )
    
    local startFrame = sldRange.value as integer
    local endFrame = sldRange.range.y as integer
    local prefix = edtPrefix.text
    
    local baseScaleFactor = spnScaleFactor.value
    local scaleIncrement = try(edtScaleIncrement.text as float)catch(0.0)
    
    local actualScale = if baseScaleFactor < 0 then
        (abs baseScaleFactor)  -- 负值：取绝对值作为缩放比例
    else if baseScaleFactor == 0 then
        1.0  -- 零值：保持原大小
    else
        baseScaleFactor  -- 正值：直接使用
    
    local origObjs = if chkSelected.checked then selection as array else objects as array
    origObjs = for obj in origObjs where not (isSnapshotObject obj prefix) and not obj.isHidden collect obj
    
    if origObjs.count == 0 then
    (
        lblStatus.text = "没有有效对象!"
        updateProgress 0 "没有可操作的对象!\n可能原因：\n1. 全是快照对象\n2. 没有选中对象"
        redrawViews()
        
        return false
    )
    
    local animObjs = #()
    local skinObjs = #()  -- 存储带有蒙皮修改器的对象
    local boneObjs = #()
    
    for obj in origObjs do
    (
        if hasSkinModifier obj then
        (
            append skinObjs obj
            format "检测到蒙皮对象: %\n" obj.name
        )
    )
    
    -- 检测骨骼对象
    for obj in origObjs do
    (
        if isBoneObject obj then
        (
            append boneObjs obj
            format "检测到骨骼对象: %\n" obj.name
        )
    )
    
    -- 检测其他对象的动画（包括蒙皮骨骼动画）
    for obj in origObjs do
    (
        if hasAnimationData obj do 
        (
            append animObjs obj
            format "检测到动画对象: %\n" obj.name
        )
    )
    
    for obj in skinObjs do
    (
        if hasSkinBoneAnimation obj and (findItem animObjs obj == 0) then
        (
            append animObjs obj
            -- format "检测到蒙皮骨骼动画对象: %\n" obj.name
        )
    )
    
    if animObjs.count == 0 and boneObjs.count > 0 then
    (
        animObjs = boneObjs
        -- format "使用骨骼对象作为动画源\n"
    )
    
    if animObjs.count == 0 and skinObjs.count > 0 then
    (
        animObjs = skinObjs
        -- format "使用蒙皮对象作为动画源（可能无动画）\n"
    )
    
    if animObjs.count == 0 then
    (
        lblStatus.text = "选择的模型没有动画数据!"
        updateProgress 0 "选中模型无动画数据！"
        redrawViews()
        return false
    )
    
    local animInfo = "检测到 " + animObjs.count as string + " 个动画对象: "
    for i = 1 to (amin #(animObjs.count, 3)) do
    (
        animInfo += animObjs[i].name
        if i < (amin #(animObjs.count, 3)) then animInfo += ", "
    )
    if animObjs.count > 3 then animInfo += "..."
    
    lblStatus.text = animInfo
    redrawViews()
    
    local currentIncrementalScale = 1.0  -- 初始增量缩放值
    
    updateProgress 0 "正在准备生成快照..."
    local totalFrames = (endFrame - startFrame) / interval + 1
    
    local numDigits = (totalFrames as string).count
    if numDigits < 2 do numDigits = 2
    
    local formatStr = "0" + (numDigits as string) + "d"
    
    local currentProgress = 0
    
    undo "Generate Snapshot" on
    (
        disableSceneRedraw()
        local newObjs = #()
        
        -- 获取所有需要冻结和隐藏的对象（非快照对象）
        local objectsToFreezeAndHide = for obj in objects where not (matchPattern obj.name pattern:(prefix + "*")) collect obj
        
        for f = startFrame to endFrame by interval do
        (
            sliderTime = f
            for obj in animObjs do
            (
                local newObj = snapshot obj

                local frameNumStr = formattedPrint (currentProgress+1) format:formatStr
                newObj.name = prefix + frameNumStr
                
                -- 计算总缩放比例：基础缩放 × 增量缩放
                local totalScale = actualScale * currentIncrementalScale
                
                -- 确保缩放值不为零（避免对象消失）
                if totalScale == 0.0 then totalScale = 0.001
                
                newObj.scale = [totalScale, totalScale, totalScale]
                
                -- 确保快照对象是可见的
                newObj.isHidden = false
                
                append newObjs newObj
            )
            currentIncrementalScale += scaleIncrement
            
            currentProgress += 1
            local percent = (currentProgress/totalFrames*100)
            updateProgress percent ("正在生成快照: " + (percent as integer) as string + "%")
            
            redrawViews()
            windows.processPostedMessages()
        )
        
        -- 冻结和隐藏所有非快照对象（原始模型、辅助对象等）
        if objectsToFreezeAndHide.count > 0 do
        (
            updateProgress 90 "正在冻结和隐藏非快照对象..."
            redrawViews()
            for obj in objectsToFreezeAndHide do 
            (
                obj.isFrozen = true
                obj.isHidden = true
            )
        )
        
        select newObjs
        enableSceneRedraw()
    )
    
    updateProgress 100 "快照生成完成!"
    lblStatus.text = "生成 " + newObjs.count as string + " 个快照并冻结隐藏" + objectsToFreezeAndHide.count as string + "个非快照对象"
    redrawViews()
    
    newObjs
)

    fn updateButtonState = 
    (
        if chkCreateSnapshot.checked then
        (
            btnAction.text = "生成快照"
            btnAction.toolTip = "创建快照并根据设置导出文件"
        )
        else
        (
            btnAction.text = "导出文件"
            btnAction.toolTip = "直接导出选定文件"
        )
    )
	
	
    on btnAction pressed do
    (
        if chkCreateSnapshot.checked then
        (
            local result = createSnapshots()
            if chkExportFmc.checked or chkExportPos.checked then
            (
                if result != false then exportAllFiles result
            )
            else
            (
				lblStatus.text = "快照生成完成！"
				updateProgress 100 "快照生成完成！"
            )
        )
        else
        (
            local objs = if chkSelected.checked then selection as array else objects as array
            exportAllFiles objs
        )
    )
    
    on btnClearSnapshots pressed do
    (
        clearSnapshots()
    )
    
    on chkCreateSnapshot changed state do
    (
        updateButtonState()
    )
	-- 自动设置按钮的逻辑
on btnAutoSetup pressed do
(
    local selection = getCurrentSelection()
    if selection.count == 0 then
    (
		lblStatus.text = "请先选择要置底的模型！"
		updateProgress 0 "未选中模型！"
		redrawViews()
        return false
    )
    
    local names = for obj in selection collect obj.name
    
    -- 按数字后缀排序
    fn compareNumericSuffix a b =
    (
        local numA = extractNumberSuffix a
        local numB = extractNumberSuffix b
        
        case of
        (
            (numA < numB): -1
            (numA > numB): 1
            default: 0
        )
    )
    
    qsort names compareNumericSuffix
    
    local downdu = getnodebyname "置底设置"
    if downdu == undefined then
    (
        downdu = Dummy length:0.1 width:0.1 height:0.1
        downdu.name = "置底设置"
    )
    
    local str = ""
    for i = 1 to names.count do (str += names[i] + ",")
    setUserProp downdu "Down" str
    
    if (zhidi != undefined and zhidi.isDisplayed) then
    (
        local sortedText = stringstream ""
        for i = 1 to names.count do (format "%\n" names[i] to:sortedText)
        zhidi.text1.text = sortedText as string
    )
    lblStatus.text = "已自动设置 " + names.count as string + " 个模型为置底并按数字排序"
)
	-- 置底button
on btnBottomSettings pressed do
(
    -- 获取当前置底设置
    local downArray = #()
    local downdu = getnodebyname "置底设置"
    if downdu != undefined then
    (
        local dostr = getUserProp downdu "Down"
        if dostr != undefined then (downArray = StrAsArray (dostr as string))
    )
    
    -- 如果没有设置，则从当前选择获取
    if downArray.count == 0 then
    (
        local out = getCurrentSelection()
        for i = 1 to out.count do (append downArray out[i].name)
    )
    
    -- 按数字后缀从小到大排序
    if downArray.count > 0 then
    (
        fn compareNumericSuffix a b =
        (
            local numA = extractNumberSuffix a
            local numB = extractNumberSuffix b
            
            case of
            (
                (numA < numB): -1
                (numA > numB): 1
                default: 0
            )
        )
        
        qsort downArray compareNumericSuffix
        
        -- 更新文本内容
        local sortedText = stringstream ""
        for i = 1 to downArray.count do (format "%\n" downArray[i] to:sortedText)
        
        -- 更新置底设置
        if downdu == undefined then
        (
            downdu = Dummy length:0.1 width:0.1 height:0.1
            downdu.name = "置底设置"
        )
        
        local str = ""
        for i = 1 to downArray.count do (str += downArray[i] + ",")
        setUserProp downdu "Down" str
    )
    
    -- 打开置底设置窗口
    createDialog zhidi modal:false style:#(#style_titlebar, #style_border, #style_sysmenu) pos:[300,300]
    
    -- 确保窗口打开后显示排序后的内容
    if downArray.count > 0 then
    (
        zhidi.text1.text = sortedText as string
    )
)
    on roSnapshot open do
    (
        updateFrameRange()
        updateButtonState()
        updateProgress 0 "等待操作..."
    )
    
    on sldRange changed val do
    (
        local currentVal = val as integer
        local range = updateFrameRange()
        
        if currentVal < range.x then sldRange.value = range.x
        if currentVal > range.y then sldRange.value = range.y
        
        lblStart.text = "开始: " + (sldRange.value as integer) as string
        lblEnd.text = "结束: " + range.y as string
        
        updateTotalFrames()
    )
    
    on rdoInterval changed state do
    (
        updateTotalFrames()
    )
    
    on btnHelp pressed do
    (
        createDialog roHelp modal:false
    )
)

createDialog roSnapshot