﻿/*
2020/06/11 0.2：将道具类以名称D_*识别，改成以“可编辑网格”类型模型区分道具类
2020/06/12 0.3：支持帧颜色导出，如需导出帧颜色请设置材质”环境光“
2020/06/14 0.4：增加不透明度导出，如需导出请设置材质“不透明度”
2020/06/16 0.5：将导出所有帧改成导出关键帧
2020/06/16 0.6：支持导出父对象关键帧
2021/08/20 0.7: 增加音频导出，增加开始结束帧设置
2022/11/10 0.7修改版：增加一些说明
*/
start = 0
end = 0

struct Trc(
	nam, --名称
	cls, --类型
	tex, --贴图
	wav, --音频
	wxh, --音频循环
	siz, --大小属性
	mod, --model
	fps, --fps
	fra = #() --帧数据
)
struct Frame(
	tim, --时间
	pos, --位置
	rot, --旋转
	siz, --大小
	opa, --不透明度
	col --颜色
)
function getwav =(
	wavnum = prosound.NumTracks()
	ret = #()
	for i = 1 to wavnum do (
		if ((prosound.active i) == false or (prosound.start i) < start or (prosound.start i) > end) then (
			continue
		)
		tmp = Trc()
		tmp.nam = "Audio_" + (i as string)
		tmp.cls = "AUDIO"
		tmp.wav = prosound.name i
		if ((prosound.NumLoops i) > 1) then(
			tmp.wxh = true
		)else(
			tmp.wxh = false
		)
		tmp.fps = frameRate
		tmpfs = Frame()
		tmpfe = Frame()
		tmpfs.pos = [0,0,0]
		tmpfs.rot = quat 0 0 0 1
		tmpfs.siz = [0,0,0]
		tmpfs.opa = 100
		tmpfs.col = color 255 255 255 255
		tmpfs.tim = (prosound.start i)-start
		tmpfe.pos = [0,0,0]
		tmpfe.rot = quat 0 0 0 1
		tmpfe.siz = [0,0,0]
		tmpfe.opa = 100
		tmpfe.col = color 255 255 255 255
		tmpfe.tim = (prosound.end i)-start
		append tmp.fra tmpfs
		append tmp.fra tmpfe
		append ret tmp
	)
	return ret
)
function getobj objs=(
	ret = #()
	for obj in objs do(
		tmp = Trc()
		tmp.nam = obj.name
		case (ClassOf obj) of (
			Editable_mesh:(--可编辑网格
				--tmp.siz = "undefined"
				tmp.cls = "MODEL"
			)
			Box:(--立方体
				tmp.siz = obj.width as string + "," + obj.length as string + "," + obj.height as string
				tmp.cls = "BOX"
			)
			Sphere:(--球
				tmp.siz = obj.radius as string + ",-90,90,90,450"
				tmp.cls = "SPHERE"
			)
			Cylinder:(--圆柱
				tmp.siz = obj.radius as string + "," + obj.radius as string + "," + obj.height as string + ",90,450"
				tmp.cls = "CYLINDER"	
			)
			Cone:(--圆锥
				tmp.siz = obj.radius2 as string + "," + obj.radius1 as string + "," + obj.height as string + ",90,450"
				tmp.cls = "CYLINDER"	
			)
			Torus:(--圆环
				tmp.siz = obj.radius2 as string + "," + obj.radius1 as string + ",90,450,90,450"
				tmp.cls = "DONUT"	
			)					
			Plane:(--平面
				tmp.siz = obj.width as string + "," + obj.length as string
				tmp.cls = "PLANE"
			)
			default:(
				continue
			)				
		)

		if (obj.Material != undefined and Classof obj.Material == StandardMaterial)then
		(
			if (obj.material.diffuseMap != undefined) then(
				tmp.tex = obj.material.diffuseMap.filename
			)
		)
		tmp.fps = frameRate --fps
		--开始取帧
		objs = #()--寄对象
		con = #()--寄存全部关键点
		
		append objs obj
		
		while (objs[objs.count].parent != undefined) do (--寄存所有父对象
			append objs objs[objs.count].parent
		)

		for j = 1 to objs.count do(
			siz = #()--寄存缩放
			pos = #()--寄存平移
			rot = #()--寄存旋转
			col = #()--寄存环境光
			opa = #()--寄存不透明度
			if objs[j].scale.isAnimated then(
				siz=objs[j].scale.Controller.keys
			)
			if objs[j].pos.isAnimated then(
				pos=objs[j].pos.Controller.keys
			)
			if objs[j].rotation.isAnimated then(
				rot=objs[j].rotation.Controller.keys
			)				
			if (objs[j].Material != undefined and Classof objs[j].Material == StandardMaterial)then(
				if objs[j].material.ambient.isAnimated then(
					col=objs[j].material.ambient.Controller.keys
				)
				if objs[j].material.opacity.isAnimated then(				
					opa=objs[j].material.opacity.Controller.keys
				)
			)
			for  z	=1 to siz.count do(
				appendIfUnique con siz[z].time
			)
			for  z	=1 to pos.count do(
				appendIfUnique con pos[z].time
			)
			for  z	=1 to rot.count do(
				appendIfUnique con rot[z].time
			)
			for  z	=1 to col.count do(
				appendIfUnique con col[z].time
			)
			for  z	=1 to opa.count do(
				appendIfUnique con opa[z].time
			)
		)
		sort con--排序
		for j= 1 to con.count do
		(
			if (con[j] < start or con[j] > end) then( -- 跳过小于开始的帧
				continue
			)
			tmpfra = Frame()
			tmpfra.tim = con[j] - start
			at time con[j]
			(
				if (obj.Material != undefined and Classof obj.Material == StandardMaterial)then(
					tmpfra.col = obj.material.ambient --环境光 alpha red green blue
					tmpfra.opa = obj.material.opacity --不透明度
				)else(
					tmpfra.col = color 255 255 255
					tmpfra.opa = 100
				)
				tmpfra.siz = obj.scale --缩放 x y z
				tmpfra.pos = obj.pos --平移
				tmpfra.rot = obj.rotation --max是 x,y,z,w
			)
			append tmp.fra tmpfra
		)
		append ret tmp
	)
	return ret
)
function OutTrc dat=(
	_txt = stringstream ""
	format "<?xml version=\"1.0\" encoding=\"GB2312\"?>\n"	to:_txt	
	format "<!--\n"											to:_txt	
	format "	# PonEF V1.01\n"							to:_txt	
	format "	# Ef Track For lxres.com\n"					to:_txt	
	format "	# 手动更改Trc文件时注意字母区分大小写！\n"		to:_txt	
	format "-->\n"											to:_txt	
	format "<SystemTrc>\n"									to:_txt	
		
	format "	<SceneObjects>%</SceneObjects>\n"	(dat.count-1)	to:_txt
	format "	<FPS>%</FPS>\n"	frameRate	to:_txt
	for i = 1 to dat.count do(
		format "	<Object_%>\n"					(i-1)					to:_txt	
		format "		<Name>%</Name>\n"			dat[i].nam				to:_txt	
		format "		<Class>%</Class>\n"			dat[i].cls				to:_txt	
		format "		<Texture>%</Texture>\n"		dat[i].tex				to:_txt	
		format "		<Wav>%</Wav>\n"				dat[i].wav				to:_txt	
		format "		<Wxh>%</Wxh>\n"				dat[i].wxh				to:_txt	
		format "		<FPS>%</FPS>\n"				dat[i].fps				to:_txt	
		format "		<Model>%</Model>\n"			dat[i].mod				to:_txt	
		format "		<Size>%</Size>\n"			dat[i].siz				to:_txt
		format "		<Frames>%</Frames>\n"		(dat[i].fra.count-1)	to:_txt	
		for j= 1 to dat[i].fra.count do
		(
			format "		<Frames_%>"	(j-1)						to:_txt
			format "%;" (dat[i].fra[j].tim)														to:_txt
			format "%,%,%;%,%,%,%;" dat[i].fra[j].pos.x dat[i].fra[j].pos.y dat[i].fra[j].pos.z dat[i].fra[j].rot.x dat[i].fra[j].rot.y dat[i].fra[j].rot.z dat[i].fra[j].rot.w					to:_txt
			format "%,%,%;%,%,%,%" dat[i].fra[j].siz.x dat[i].fra[j].siz.y dat[i].fra[j].siz.z (dat[i].fra[j].opa/100.0) (dat[i].fra[j].col.red/255.0) (dat[i].fra[j].col.green/255.0) (dat[i].fra[j].col.blue/255.0)	to:_txt
			format "</Frames_%>\n"	(j-1)														to:_txt				
		)
		format "	</Object_%>\n"					(i-1)					to:_txt	
	)
	format "</SystemTrc>\n"									to:_txt
	return _txt
)
rollout TrcRollout "流星TRC特效轨迹导出 0.7 修改版" width:417 height:168
(

	button NewBtn "开始" pos:[280,122] width:124 height:32

	Edittext FramesStart "开始帧：" text:"0" pos:[24,42] width:164 height:16
	Edittext FramesEnd "结束帧：" text:"0" pos:[24,62] width:164 height:16
	checkbox OutWav "导出音效" pos:[74,82] width:120 height:14 align:#left checked:true
	
	label titleLabel1 "请设置导出的参数" pos:[12,12] width:150 height:16
--新增	
	label titleLabel2 "提示：\n1，当前版本仅支持ef编辑器0.2.1\n2，导出平面或立方体时，模型x中心轴必须旋转90°\n3，可在图形编辑器-摄影表添加音频\n4，模型轴心必须居中中心轴" pos:[221,12] width:180 height:100
--
	
	GroupBox grp1 "" pos:[6,0] width:200 height:108
	
	HyperLink add0 "To Lxres.com" pos:[8,148] width:124 height:16 address:"www.lxres.com" color:(color 94 234 255) hovercolor:(color 255 0 0)

	on TrcRollout open  do(
		FramesStart.text = ((animationRange.Start as integer)/TicksPerFrame) as string
		FramesEnd.text = ((animationRange.end as integer)/TicksPerFrame) as string
	)

	on NewBtn pressed do
	(
		start = FramesStart.text as Integer
		end = FramesEnd.text as Integer
		if ($ == undefined and OutWav.checked == false) then(
			MessageBox("请选择导出对象！")
			return -1
		)
		if (end < start)then(
			MessageBox("结束不能小于开始！")
			return -1
		)
		if (end<0 or start<0)then(
			MessageBox("不能小于0！")
			return -1
		)
		dat = #()
		if ($ != undefined)then(
			dat = getobj $
		)
		if (OutWav.checked)then(
			join dat (getwav())
		)

		out_name =getSaveFileName types:"流星EF轨迹文件 (*.trc)|*.trc|All (*.*)|*.*|" caption:"导出trc文件"
		if out_name == undefine then (
			return -1
		)
		try (
			out_file = createfile out_name /*创建输出文件*/
			format "%" ((outtrc dat) as string) to:out_file
			close out_file
			MessageBox("导出成功！")
		) catch (
			local e = getCurrentException()
			MessageBox(e)
		)
	)
)

createDialog TrcRollout
