﻿/*
流星蝴蝶剑.net 路径点wp导出工具_v1.0.0
20250617
功能：
1，实现基础路径点导出，兼容3dsmax2016~2025

说明：
1，修改器面板中找到-辅助对象-虚拟对象

过山河。
*/
try(destroyDialog rolExportWaypoints)catch()
rollout rolExportWaypoints "流星蝴蝶剑.net路径点wp导出工具" width:280 height:100
(
    local waypoints = #()
    local connections = #()
    
	label shuoming1 "使用说明：新建Dummy，设置好大小，全选导出" align:#left offset:[10,10]
	
    button btnExport "导出文件(.wp)" width:200 height:40 align:#center offset:[0,15]
	
	
    fn formatFloat val n:3 =
    (
        local factor = 10.0 ^ n
        local scaledVal = val * factor
        local intVal = if scaledVal >= 0 then (scaledVal + 0.5) as integer else (scaledVal - 0.5) as integer
        local result = (intVal as float) / factor
        
        local str = result as string
        local dotPos = findString str "."
        if dotPos == undefined do
        (
            str += "."
            dotPos = str.count
        )
        
        local decimals = str.count - dotPos
        for i = 1 to (n - decimals) do str += "0"
        str
    )
    -- 计算两点间距离
    fn calculateDistance obj1 obj2 = (distance obj1.pos obj2.pos)
    -- 0表示可以走动的线，1，表示带有跳跃的线，2表示单向（通常用在绝境、z高低差）
    fn getLinkFlag obj1 obj2 = 
    (
        local deltaZ = abs(obj1.pos.z - obj2.pos.z)
        case of
        (
            (deltaZ < 50): 0
            (deltaZ < 100): 1
            default: 2
        )
    )
    
    fn compareByHandle a b = 
    (
        if a.inode.handle < b.inode.handle then -1 else 1
    )
    
    fn getDummySize dummy = 
    (
        local boxSize = dummy.boxsize
        local sizeValue = sqrt(boxSize.x^2 + boxSize.y^2 + boxSize.z^2)
        case of
        (
            (sizeValue <= 15): 10
            (sizeValue <= 40): 40
            (sizeValue <= 70): 70
            default: 100
        )
    )
    -- 导出数据到文件
    on btnExport pressed do
    (
        local dummies = for obj in selection where classOf obj == Dummy collect obj
        
        if dummies.count == 0 then 
        (
            messageBox "请先选择虚拟辅助对象(Dummy)!" title:"错误"
            return undefined
        )
        
        qsort dummies compareByHandle
        waypoints = #()
        connections = #()
        local maxDistance = 400 --每个点的最大阈值?
        
        -- 遍历辅助点数据
        for i = 1 to dummies.count do
        (
            local dummy = dummies[i]
            local size = getDummySize dummy
            append waypoints #(dummy, size)
            append connections #() 
        )
        
        for i = 1 to dummies.count do
        (
            local dummyA = dummies[i]
            for j = (i+1) to dummies.count do
            (
                local dummyB = dummies[j]
                local dist = calculateDistance dummyA dummyB
                
                if dist <= maxDistance then 
                (
                    local flag = getLinkFlag dummyA dummyB
                    append connections[i] #(j-1, flag, dist)
                    append connections[j] #(i-1, flag, dist)
                )
            )
        )
        
        local savePath = getSaveFileName caption:"保存流星蝴蝶剑.net路径点数据" types:"Waypoint File(*.wp)|*.wp|All Files(*.*)|*.*"
        if savePath == undefined then return undefined
        
        if not matchPattern savePath pattern:"*.wp" do savePath += ".wp"
        
        local f = createFile savePath
        if f == undefined then 
        (
            messageBox "无法创建文件!" title:"错误"
            return undefined
        )
        
        format "WayPoints %\n" waypoints.count to:f
        
        for i = 1 to waypoints.count do
        (
            local dummy = waypoints[i][1]
            local size = waypoints[i][2]
            local links = connections[i]
            
            format "Pos % % %\n" (formatFloat dummy.pos.x) \
                                  (formatFloat dummy.pos.y) \
                                  (formatFloat dummy.pos.z) to:f
            
            format "Size %\n" size to:f
            
            format "Link %\n" links.count to:f
            for link in links do 
            (
                format "% % %\n" link[1] link[2] (formatFloat link[3]) to:f
            )
        )
        
        close f
        messageBox ("已经导出到:\n" + savePath) title:"导出完成"
    )
)

createDialog rolExportWaypoints