﻿--
-- fmc&pos动画辅助工具
-- 过山河。
--
-- 
-- 修正帧范围逻辑
-- 整合导出pos和fmc文件逻辑
-- 修改快照后删除原对象逻辑，一键化操作
-- v1.1.0
-- 20250906
-- 
-- v1.0.0
-- 20250801
--
-- 

try (destroyDialog roSnapshot) catch ()

rollout roSnapshot "fmc&pos动画辅助工具" width:320 height:450
(
    group "快照设置"
    (
        label lblInterval "快照间隔:" align:#left offset:[-5,0]
        radiobuttons rdoInterval labels:#("逐帧", "隔一帧", "隔两帧") default:1 columns:3 offset:[0,5]
        checkbox chkSelected "仅选中的对象" checked:true tooltip:"不勾选则对场景所有对象操作" offset:[0,5]
        checkbox chkDeleteOriginal "快照后删除原对象" checked:true tooltip:"慎用! 将删除所有非快照对象" offset:[0,5]
    )
    
    group "帧范围"
    (
        slider sldRange "帧范围:" range:[0,100,0] width:290 height:30 ticks:10 offset:[0,5]
        label lblStart "开始帧: 0" align:#left across:2 offset:[0,5]
        label lblEnd "结束帧: 100" align:#right offset:[0,5]
    )
    
    group "命名规则"
    (
        edittext edtPrefix "前缀:" text:"SN_" fieldWidth:200
    )
    
    group "导出设置"
    (
        checkbox chkCreateSnapshot "创建快照" checked:true align:#left tooltip:"勾选则创建快照，不勾选则直接导出当前模型"
        editText edtZValue "Z轴偏移值:" fieldWidth:70 text:"-100.0" align:#right offset:[0,0]
        checkbox chkExportPos "导出pos文件" checked:true align:#left offset:[0,-20]
    )
    
    button btnAction "生成快照" width:200 height:40 align:#center
    
    group "更新"
    (
        label lblVersion "fmc动画辅助工具 Ver 1.1.0" align:#center offset:[0,5]
        hyperlink hlUpdate "更多工具请访问流星资源网" address:"www.lxres.com" align:#center offset:[0,5] color:(color 94 234 255) hovercolor:(color 255 0 0)
    )
    
    -- 帮助按钮
    button btnHelp "?" width:20 height:20 align:#right offset:[-10,-60] toolTip:"点击查看使用说明"
    
    -- 帮助窗口
    rollout roHelp "使用说明" width:400 height:200
    (
        label lblHelp1 "1. 加载单独的动画模型，任意模型动画" align:#left offset:[10,10]
        label lblHelp2 "2. 选择需要的快照模式，如果动画时长段，则默认逐帧" align:#left offset:[10,0]
        label lblHelp3 "3. 拖动帧范围滑块，脚本会自动刷新帧长度" align:#left offset:[10,0]
        label lblHelp4 "4. 取好名字（自定义）" align:#left offset:[10,0]
        label lblHelp5 "5. 勾选快照仅生成快照，不勾选仅导出fmc/pos" align:#left offset:[10,0]
        label lblHelp6 "6. z轴偏移值一般不用改动！" align:#left offset:[10,0]
        label lblHelp7 "7. 注意，记得在创建快照后用模型导出脚本导出gmb和des！"align:#left offset:[10,0]
        label lblNoteTitle "注意事项：" align:#left offset:[10,15] font:(dotNetObject "System.Drawing.Font" "Microsoft YaHei" 10 (dotNetClass "System.Drawing.FontStyle").Bold)
        label lblNote1 "- 确保有足够的磁盘空间存储快照" align:#left offset:[20,0]
        label lblNote2 "- 复杂场景的快照可能需要较长时间" align:#left offset:[20,0]
        
        --button btnClose "关闭" width:80 height:30 align:#center offset:[0,15]
        
        on btnClose pressed do
        (
            destroyDialog roHelp
        )
    )
    
    fn getSceneAnimationRange = 
    (
        return [animationRange.start.frame as integer, animationRange.end.frame as integer]
    )
    
    fn getKeyframeRange = 
    (
        local allKeys = #()
        local objs = objects
        
        for obj in objs where not obj.isHidden do
        (
            try (join allKeys (getKeyTimes obj.controller)) catch ()
        )
        
        if allKeys.count > 0 then
        (
            local minKey = amin allKeys
            local maxKey = amax allKeys
            return [minKey.frame as integer, maxKey.frame as integer]
        )
        else
        (
            return getSceneAnimationRange()
        )
    )
    
    fn updateFrameRange = 
    (
        local range = getKeyframeRange()
        local sceneRange = getSceneAnimationRange()
        
        local actualStart = (amin #(range.x, sceneRange.x)) as integer
        local actualEnd = (amax #(range.y, sceneRange.y)) as integer
        
        sldRange.range = [actualStart as float, actualEnd as float, sldRange.value as float]
        lblStart.text = "开始帧: " + (sldRange.value as integer) as string
        lblEnd.text = "结束帧: " + actualEnd as string
        
        return [actualStart, actualEnd]
    )
    
    fn compareByName a b = 
    (
        case of
        (
            (a.name < b.name): -1
            (a.name > b.name): 1
            default: 0
        )
    )
    
    fn exportFmcPos objs = 
    (
        local zValue = try(edtZValue.text as float)catch(0.0)
        
        if objs.count == 0 then
        (
            messageBox "没有可导出的模型！" title:"错误" beep:true
            return false
        )
        
        qsort objs compareByName
        local totalFrames = objs.count
        
        local saveFmcPath = getSaveFileName \
            caption:"保存fmc文件" \
            filename:(getDir #export + "\\sequence_export.fmc") \
            types:"fmc文件(*.fmc)|*.fmc|"
        
        if saveFmcPath == undefined then return false
        
        local savePosPath = pathConfig.appendPath (getFilenamePath saveFmcPath) (getFilenameFile saveFmcPath + ".pos")
        local originalPositions = #()
        for obj in objs do append originalPositions [obj.pos.x, obj.pos.y, obj.pos.z]
        
        local fmcFile, posFile
        
        try
        (
            fmcFile = createFile saveFmcPath
            if fmcFile == undefined then throw "fmc文件创建失败"
            
            if chkExportPos.checked then
            (
                posFile = createFile savePosPath
                if posFile == undefined then throw "pos文件创建失败"
            )
            
            format "# GModel Animation File V1.0\n" to:fmcFile
            format "# 这一行留空,不能删除\n" to:fmcFile
            format "SceneObjects % DummeyObjects 0\n" totalFrames to:fmcFile
            format "FPS 60 Frames % Mode: RIGID\n" totalFrames to:fmcFile
            
            for f = 0 to (totalFrames-1) do
            (
                if chkExportPos.checked then
                (
                    format "pose\n{\n" to:posFile
                    format "  start %\n" f to:posFile
                    format "  end   %\n" f to:posFile
                    format "}\n" to:posFile
                )
                
                format "frame %\n{\n" f to:fmcFile
                
                for i = 1 to totalFrames do
                (
                    local obj = objs[i]
                    local originalPos = originalPositions[i]
                    local useZ = if (i-1) == f then originalPos.z else zValue
                    local currentPos = [originalPos.x, originalPos.y, useZ]
                    
                    local rot = obj.rotation as quat
                    
                    format " t % % %  q % % % %\n" \
                        currentPos.x currentPos.y currentPos.z \
                        rot.w rot.x rot.y rot.z to:fmcFile
                )
                
                format "}\n" to:fmcFile
            )
            
            close fmcFile
            if chkExportPos.checked then close posFile
            
            messageBox ("导出完成！\nFMC: " + saveFmcPath + \
                      (if chkExportPos.checked then "\nPOS: " + savePosPath else "")) \
                      title:"完成"
            return true
        )
        catch
        (
            if fmcFile != undefined then try(close fmcFile)catch()
            if posFile != undefined then try(close posFile)catch()
            
            messageBox ("导出失败:\n" + (getCurrentException())) title:"错误" beep:true
            return false
        )
    )
    
    fn createSnapshots = 
    (
        local newObjs = #()
        
        if chkSelected.checked and selection.count == 0 then
        (
            messageBox "请先选中要快照的模型!" title:"警告"
            return false
        )
        
        local interval = case rdoInterval.state of
        (
            1: 1
            2: 2
            3: 3
        )
        
        local startFrame = sldRange.value as integer
        local endFrame = sldRange.range.y as integer
        local prefix = edtPrefix.text
        local counter = 1
        
        undo "Generate Snapshot" on
        (
            disableSceneRedraw()
            
            local origObjs = if chkSelected.checked then selection as array else objects as array
            local objectsToDelete = #()
            
            if chkDeleteOriginal.checked do objectsToDelete = objects as array
            
            for f = startFrame to endFrame by interval do
            (
                sliderTime = f
                
                for obj in origObjs where not obj.isHidden do
                (
                    local newObj = snapshot obj
                    newObj.name = prefix + (formattedPrint counter format:"02d")
                    append newObjs newObj
                    
                    if chkDeleteOriginal.checked do
                    (
                        local index = findItem objectsToDelete newObj
                        if index != 0 do deleteItem objectsToDelete index
                    )
                    
                    counter += 1
                )
            )
            
            if chkDeleteOriginal.checked and objectsToDelete.count > 0 do
            (
                clearSelection()
                for i = objectsToDelete.count to 1 by -1 do
                (
                    try (delete objectsToDelete[i]) catch ()
                )
            )
            
            select newObjs
            enableSceneRedraw()
        )
        
        return newObjs
    )
    
    fn updateButtonState = 
    (
        if chkCreateSnapshot.checked then
        (
            btnAction.text = "生成快照"
            btnAction.toolTip = "仅创建快照"
        )
        else
        (
            btnAction.text = "导出FMC/POS"
            btnAction.toolTip = "仅导出FMC和POS文件"
        )
    )
    
    on roSnapshot open do
    (
        updateFrameRange()
        updateButtonState()
    )
    
    on chkCreateSnapshot changed state do
    (
        updateButtonState()
    )
    
    on sldRange changed val do
    (
        local currentVal = val as integer
        local range = updateFrameRange()
        
        if currentVal < range.x then sldRange.value = range.x
        if currentVal > range.y then sldRange.value = range.y
        
        lblStart.text = "开始帧: " + (sldRange.value as integer) as string
        lblEnd.text = "结束帧: " + range.y as string
    )
    
    on btnAction pressed do
    (
        if chkCreateSnapshot.checked then
        (
            -- 创建快照模式
            local newObjs = createSnapshots()
            if newObjs != false then
            (
                messageBox ("成功创建 " + newObjs.count as string + " 个快照对象！") title:"完成"
            )
        )
        else
        (
            -- 直接导出模式
            local objsToExport = if chkSelected.checked then selection as array else objects as array
            
            if objsToExport.count == 0 then
            (
                messageBox "没有可导出的模型！" title:"警告"
                return false
            )
            
            exportFmcPos objsToExport
        )
    )
    
    on btnHelp pressed do
    (
        createDialog roHelp modal:false style:#(#style_titlebar, #style_border, #style_sysmenu)
    )
)

createDialog roSnapshot