﻿/*
流星蝴蝶剑.net fmc、pos导出工具_v1.0.3
20250803
功能：
1，同时导出fmc和pos文件，兼容3dsmax2016~2025

说明：
1，使用任意动画模型，创建多个快照，全选后点击导出即可。不需要修改z轴偏移值,注意模型必须放在原点(0 0 0)
2，该脚本会同时生成pos文件，这些pos和fmc都是特定的，和官方的不一样。需要配合as脚本使用(非强制)
3，如果道具没有阴影，请将z值降低，避免超出光影范围

过山河。
*/
try(destroyDialog fmcExporterRollout)catch()

rollout fmcExporterRollout "流星蝴蝶剑.netfmc,pos导出工具" width:280 height:100
(
    editText edtZValue "Z轴偏移值:" fieldWidth:70 text:"-1000.0" align:#right offset:[10,0]
    checkbox chkExportPos "同时导出.pos文件" checked:true align:#left offset:[128,0]
    button btnExport "导出文件" width:200 height:40 align:#center toolTip:"导出fmc动画文件，可选导出pos文件"
    
    fn compareByName a b = 
    (
        case of
        (
            (a.name < b.name): -1
            (a.name > b.name): 1
            default: 0
        )
    )
    
    on btnExport pressed do
    (
        -- 获取Z轴值
        local zValue = try(edtZValue.text as float)catch(0.0)
        
        -- 获取选中的几何体模型
        local validObjs = if selection.count > 0 then
            (for obj in selection where (superClassOf obj == GeometryClass) collect obj)
        else
            (for obj in objects where (superClassOf obj == GeometryClass) collect obj)
            
        if validObjs.count == 0 then
        (
            messageBox "没有找到有效模型！" title:"错误" beep:true
            return undefined
        )
        
        -- 按名称排序
        qsort validObjs compareByName
        local totalFrames = validObjs.count
        
        -- 保存文件对话框
        local saveFmcPath = getSaveFileName \
            caption:"保存fmc文件" \
            filename:(getDir #export + "\\sequence_export.fmc") \
            types:"fmc文件(*.fmc)|*.fmc|"
        
        if saveFmcPath == undefined then return undefined
        
        -- 生成对应的.pos文件路径
        local savePosPath = pathConfig.appendPath (getFilenamePath saveFmcPath) (getFilenameFile saveFmcPath + ".pos")
        
        -- 记录原始位置
        local originalPositions = #()
        for obj in validObjs do append originalPositions [obj.pos.x, obj.pos.y, obj.pos.z]
        
        local fmcFile, posFile
        
        try
        (
            -- 创建并写入fmc文件
            fmcFile = createFile saveFmcPath
            if fmcFile == undefined then throw "fmc文件创建失败"
            
            -- 根据复选框决定是否创建pos文件
            if chkExportPos.checked then
            (
                posFile = createFile savePosPath
                if posFile == undefined then throw "pos文件创建失败"
            )
            
            -- 写入fmc文件头
            format "# GModel Animation File V1.0\n" to:fmcFile
            format "# 这一行留空,不能删除，删除无动画！\n" to:fmcFile
            format "SceneObjects % DummeyObjects 0\n" totalFrames to:fmcFile
            format "FPS 60 Frames % Mode: RIGID\n" totalFrames to:fmcFile
            
            -- 生成序列数据并写入文件
            for f = 0 to (totalFrames-1) do
            (
                -- 如果勾选了导出pos，则写入pos文件数据
                if chkExportPos.checked then
                (
                    format "pose\n{\n" to:posFile
                    format "  start %\n" f to:posFile
                    format "  end   %\n" f to:posFile
                    format "}\n" to:posFile
                )
                
                -- 写入fmc帧数据
                format "frame %\n{\n" f to:fmcFile
                
                for i = 1 to totalFrames do
                (
                    local obj = validObjs[i]
                    local originalPos = originalPositions[i]
                    local useZ = if (i-1) == f then originalPos.z else zValue
                    local currentPos = [originalPos.x, originalPos.y, useZ]
                    
                    local rot = obj.rotation as quat
                    
                    -- 写入fmc模型数据
                    format " t % % %  q % % % %\n" \
                        currentPos.x currentPos.y currentPos.z \
                        rot.w rot.x rot.y rot.z to:fmcFile
                )
                
                format "}\n" to:fmcFile
            )
            
            -- 关闭文件
            close fmcFile
            if chkExportPos.checked then close posFile
            fmcFile = undefined
            posFile = undefined
            
            -- 导出日志，可不显示
            local report = "导出完成！\n"
            --report += "? 模型/帧总数: " + totalFrames as string + "\n"
            --report += "? Z轴偏移值: " + zValue as string + "\n\n"
            --report += "? fmc文件:\n" + saveFmcPath + "\n\n"
            --report += "? pos文件:\n" + savePosPath + "\n\n"
            --report += "pos文件包含 " + totalFrames as string + " 个帧范围定义"
            
            messageBox report title:"导出完成"
        )
        catch
        (
            -- 确保文件关闭
            if fmcFile != undefined then try(close fmcFile)catch()
            if posFile != undefined then try(close posFile)catch()
            
            -- 获取错误信息
            local errMsg = ""
            try (errMsg = getCurrentException() as string) 
            catch (errMsg = "未知错误")
            
            -- 构建完整错误信息
            local fullErr = "导出过程出错:\n" + errMsg + "\n\n"
            fullErr += "请检查以下可能的原因:\n"
            fullErr += "1. 文件保存路径是否有写入权限\n"
            fullErr += "2. 模型是否有特殊变换属性\n"
            fullErr += "3. 是否安装了特殊插件导致对象行为异常"
            
            messageBox fullErr title:"严重错误" beep:true
        )
    )
)

createDialog fmcExporterRollout