struct MC_OBJ(
    tex,--名称
    mat=#(),--材质
    ver=#(),--顶点
    fac=#(),--面
    mid=#(),--面材质ID
    --动画帧
    sca=#(),--缩放
    rot=#(),--旋转
    pos=#(),--坐标
    trf=#(),--Transform
    typ,--类型
    fuv,--uv动画
    def=#()--变形
)
struct LX_VERT( --顶点uv
    vert,uv
)
struct LX_FAC( --面
    id,fac
)
struct LX_FRA( --动画帧
    sca,rot,pos
)
struct	LX_Tex( --材质
    tex,--贴图名
    fil,--过滤色
    shs,--高光泽度
    shi,--光泽度
    opa,--不透明度
    mix_col,--混合
    sel,--自发光
    sid,--边，线框 
    amb,--环境色光
    dif,--漫反射光
    spe--高光反射光
)
struct LX_FAR( --动画帧
    z_x,--x轴缩放
    str1,--拉伸1
    z_y,--y轴缩放
    str2,--拉伸2
    un1,--未知
    pos--坐标
)
struct LX_OUT( --导出部件
    obj,--对象
    typ,--类型
    fuv--动画
)
out=#() --导出部件寄存

fn obj_filt obj = isKindof obj Editable_mesh --可编辑网格

fn exportLx	arg int1 int2 str1 str2 str3 str4=
(
    out_mc=#() --寄存数据
    for i = 1 to out.count do
	(
		select out[i].obj
		tmpmesh = snapshotAsMesh out[i].obj

        out_mc[i] = MC_OBJ()

        out_mc[i].tex = out[i].obj.name
        out_mc[i].typ = out[i].typ
        out_mc[i].fuv = 0 --out[i].fuv

		/*取所有材质*/
		m = out[i].obj.material
		mtype = classof  m
		--format "	*******	调试输出	 步骤=%	,	%\n"		"开始读取材质类型　==" 	  mtype
		case mtype of (
			Standardmaterial:(/*单材质*/
				aTex = LX_Tex()
				try (
					aTex.tex	=	m.diffuseMap.filename
				) catch (
					aTex.tex	=	"NONE"
				)
				aTex.fil	=	m.filterColor	--过滤色
                aTex.shs    =   m.specularLevel  --高光级别
                aTex.shi    =   m.glossiness--光泽度
				aTex.opa	=	m.opacity 	/	100.0		--不透明度
                aTex.mix_col=   2  --混合
				aTex.sel	=	m.selfIllumAmount--自发光
                aTex.sid    =   m.wireSize--线框
				aTex.amb	=	m.ambient--环境色光
				aTex.dif	=	m.diffuse--漫反射光
				aTex.spe	=	m.specular--高光反射光
				append	out_mc[i].mat		aTex
			)/*单材质*/
			PhysicalMaterial:(/*物理材质*/
                MessageBox("不支持物理材质!") title:"错误!" beep:false
                return -3
			)/*物理材质*/
			Multimaterial:(/*多维材质*/
				for j = 1 to m.numsubs do
				(
					mtype1 = classof  m.materialList[j]
					case mtype1 of (
						Standardmaterial:(
                            aTex = LX_Tex()
                            try (
                                aTex.tex	=	m.materialList[j].diffuseMap.filename
                            ) catch (
                                aTex.tex	=	"NONE"
                            )
                            aTex.fil	=	m.materialList[j].filterColor	--过滤色
                            aTex.shs    =   m.materialList[j].specularLevel  --高光级别
                            aTex.shi    =   m.materialList[j].glossiness--光泽度
                            aTex.opa	=	m.materialList[j].opacity 	/	100.0		--不透明度
                            aTex.mix_col=   2  --混合
                            aTex.sel	=	m.materialList[j].selfIllumAmount--自发光
                            aTex.sid    =   m.materialList[j].wireSize--线框
                            aTex.amb	=	m.materialList[j].ambient--环境色光
                            aTex.dif	=	m.materialList[j].diffuse--漫反射光
                            aTex.spe	=	m.materialList[j].specular--高光反射光
                            append	out_mc[i].mat		aTex
						)
						PhysicalMaterial:(
                            MessageBox("不支持物理材质!") title:"错误!" beep:false
                            return -3
                        )
						default:(body)
					)
				)
			)/*多维材质*/
			
			/*
			
					MessageBox(out[i].name + " 存在空白的子材质！不推荐使用多维材质，容易出现贴图错乱！") title:"错误!" beep:false
					return -3
			
			*/

			default:(
				MessageBox(out[i].obj.name + " 没有材质!") title:"错误!" beep:false
				return -3	
			)
		)
		/*取材质结束*/

		/*取面和顶点*/
        flo1 = 1 as float
		for v = 1 to tmpmesh.numverts do
		(
			vv  = getVert 	tmpmesh 	v
			try(
				uv = getTVert 	tmpmesh 	v
			)catch(
				MessageBox(out[i].obj.name + " 网格或顶点错误！请尝试将 " + out[i].obj.name + " 导出成3ds格式修复该错误！") title:"错误!" beep:false
				return -3
			)

			vst = LX_VERT()
            case out[i].typ of (
                0:(
                    vst.vert = (vv-out[i].obj.pos)/out[i].obj.scale
                )
                1:(
                    vst.vert = vv
                )
                default:(
                    vst.vert = (vv-out[i].obj.pos)/out[i].obj.scale
                )
            )
			vst.uv = uv
            if out_mc[i].fuv == 0 then(
                if uv.x > flo1 or uv.y > flo1 then(
                    out_mc[i].fuv = 1
                )
            )

			append out_mc[i].ver vst
		)
		
		for  f = 1 to tmpmesh.numfaces  do
		(

			tri_vertices = getFace tmpmesh f    /*取面的顶点*/
			tri_uvws     = getTVFace tmpmesh f /*取面的纹理*/
			tri_vertices2 = [tri_vertices[1],tri_vertices[2],tri_vertices[3]]
			append		out_mc[i].fac		tri_vertices2
			mID	= getFaceMatID 	tmpmesh	f
			append		out_mc[i].mid	mID	/*获取每个面的材质id*/

		)/*取面和顶点结束*/

        /*取动画帧*/
        --Animate On
        for  t	= 1	to int1 do
        (
        at time (t+int2-1) 	
            (
                case out[i].typ of (
                    0:(
                        append out_mc[i].sca out[i].obj.scale --缩放 x y z
                        append out_mc[i].pos out[i].obj.pos --平移
                        append out_mc[i].rot out[i].obj.rotation --max是 x,y,z,w			
                        append out_mc[i].trf out[i].obj.Transform --max Transform			
                    )
                    1:(
                        def = #()--寄存变形动画
                        for v = 1 to tmpmesh.numverts do
                        (
                            vv  = getVert 	(snapshotAsMesh out[i].obj) 	v
                            uv = getTVert 	(snapshotAsMesh out[i].obj) 	v
                
                            vst = LX_VERT()
                            vst.vert = vv
                            vst.uv = uv	
                            if out_mc[i].fuv == 0 then(
                                if out_mc[i].ver[v].uv.x != uv.x or out_mc[i].ver[v].uv.y != uv.y then (
                                    out_mc[i].fuv = 1
                                )
                            )
                            append def vst
                        )
                        append out_mc[i].def def             
                    )
                    default:(body)
                )
            )
        )
        --Animate off
	)/*循环结束*/

    /*开始导出*/
    exportName	=	getFilenameFile	arg/*寄存导出名字*/
		
    try(
        out_file = createfile arg /*创建输出文件*/
    )
    catch(
        MessageBox(arg + "无法写入，请检查是否被占用!") title:"错误!" beep:false
        return -3
    )
    /*-----------------------------------------------------------------------------------------
    ----								头导出开始
    -----------------------------------------------------------------------------------------*/

        format "# Morph Creature data file - exported from 3DS Max 2.5\n"	to:out_file	
        format "# Morph Creature For Lxres.com Creation Time %\n" LocalTime to:out_file	
        format "BeginBase _base % % % Version 2.0\n" int1	exportName	out_mc.count	to:out_file
        format "EndBase _base\n" 	to:out_file
        
    /*-----------------------------------------------------------------------------------------
    ----								头导出结束
    -----------------------------------------------------------------------------------------*/

    /*-----------------------------------------------------------------------------------------
    ----								模型导出开始
    -----------------------------------------------------------------------------------------*/
    for i = 1 to out_mc.count do (
        format "\nBeginObject % %\n" i out_mc[i].tex	to:out_file
        case out_mc[i].typ of (
            0:(
                format "\tSegment Mat % Detail 1\n" out_mc[i].mat.count to:out_file                
            )
            1:(
                format "\tMorph Mat % Detail 1\n" out_mc[i].mat.count to:out_file                
            )
            default:(
                format "\tSegment Mat % Detail 1\n" out_mc[i].mat.count to:out_file                
            )
        )
        --材质循环
        for j = 1 to out_mc[i].mat.count do (
            f1 = formattedPrint out_mc[i].mat[j].shs format:"0.4f"
            f2 = formattedPrint out_mc[i].mat[j].shi format:"0.4f"
            f3 = formattedPrint out_mc[i].mat[j].opa format:"0.4f"
            f4 = formattedPrint out_mc[i].mat[j].sel format:"0.4f"
            
            f5 = formattedPrint (out_mc[i].mat[j].amb.r/255) format:"0.4f"
            f6 = formattedPrint (out_mc[i].mat[j].amb.g/255) format:"0.4f"
            f7 = formattedPrint (out_mc[i].mat[j].amb.b/255) format:"0.4f"

            f8 = formattedPrint (out_mc[i].mat[j].dif.r/255) format:"0.4f"
            f9 = formattedPrint (out_mc[i].mat[j].dif.g/255) format:"0.4f"
            f10 = formattedPrint (out_mc[i].mat[j].dif.b/255) format:"0.4f"

            f11 = formattedPrint (out_mc[i].mat[j].spe.r/255) format:"0.4f"
            f12 = formattedPrint (out_mc[i].mat[j].spe.g/255) format:"0.4f"
            f13 = formattedPrint (out_mc[i].mat[j].spe.b/255) format:"0.4f"

            format "\t\tMaterial % % % % % 0 0\n" (j-1) (getFilenameFile out_mc[i].mat[j].tex) (out_mc[i].mat[j].fil.r as integer) (out_mc[i].mat[j].fil.g as integer) (out_mc[i].mat[j].fil.b as integer)	to:out_file
            format "\t\tShininess %\n" 	f1                            to:out_file
            format "\t\tShinstr %\n" f2	                            to:out_file
            format "\t\tOpacity % %\n" f3 out_mc[i].mat[j].mix_col	to:out_file
            format "\t\tSelfIllum %\n" f4	                            to:out_file
            format "\t\tSide %\n" out_mc[i].mat[j].sid	                                to:out_file
            format "\t\tAmbient % % %\n" f5 f6 f7     to:out_file
            format "\t\tDiffuse % % %\n" f8 f9 f10     to:out_file
            format "\t\tSpecular % % %\n\n" f11 f12 f13    to:out_file
        )
        --材质循环
        --顶点导出
        if out_mc[i].fuv == 1 then(
            format "\tVertices % T 0 1 0.000000 0.000000 (UV, CV)\n" out_mc[i].ver.count	to:out_file
        )else(
            format "\tVertices % T 0 0 0.000000 0.000000 (UV, CV)\n" out_mc[i].ver.count	to:out_file
        )
        for j = 1 to out_mc[i].ver.count do (
            f1 = formattedPrint out_mc[i].ver[j].vert.x format:"0.4f"
            f2 = formattedPrint out_mc[i].ver[j].vert.y format:"0.4f"
            f3 = formattedPrint out_mc[i].ver[j].vert.z format:"0.4f"
            f4 = formattedPrint out_mc[i].ver[j].uv.x format:"0.4f"
            f5 = formattedPrint out_mc[i].ver[j].uv.y format:"0.4f"
            format "\t\t% % % % %\n" f1 f2 f3 f4 f5	to:out_file
        )
        --面导出
        format "\n\tFaces %\n" out_mc[i].fac.count	to:out_file--tex_id
        for j = 1 to out_mc[i].fac.count do (
            format "\t\t% % % % %\n" 3 ((out_mc[i].mid[j] as integer)-1) ((out_mc[i].fac[j][1] as integer)-1) ((out_mc[i].fac[j][2] as integer)-1) ((out_mc[i].fac[j][3] as integer)-1)	to:out_file
        )
        format "EndObject %\n" out_mc[i].tex	to:out_file
    )
    /*-----------------------------------------------------------------------------------------
    ----								模型导出结束
    -----------------------------------------------------------------------------------------*/
    /*-----------------------------------------------------------------------------------------
    ----								动画导出开始
    -----------------------------------------------------------------------------------------*/
    format "\nBeginRelationship %\n" out_mc.count	to:out_file
    for i = 1 to out_mc.count do (
        format "\t% %\n" (i-1) 0	to:out_file
    )
    format "EndRelationship %\n" out_mc.count	to:out_file

    pose = 0
    if str1 != "" then ( pose = pose+1 )
    if str2 != "" then ( pose = pose+1 )
    if str3 != "" then ( pose = pose+1 )
    if str4 != "" then ( pose = pose+1 )

    format "\nBeginPose %\n" pose	to:out_file
    if str1 != "" then (
        format "\t0 % 0 0 0\n" str1	to:out_file
    )
    if str2 != "" then (
        format "\t1 % 0 0 0\n" str2	to:out_file
    )
    if str3 != "" then (
        format "\t2 % 0 0 0\n" str3	to:out_file
    )
    if str4 != "" then (
        format "\t3 % 0 0 0\n" str4	to:out_file
    )
    format "EndPose %\n" pose	to:out_file

    format "\nBeginMove _base\n" to:out_file
    for i = 1 to int1 do (
        f1 = formattedPrint 0 format:"0.4f"
        f2 = formattedPrint 0 format:"0.4f"
        f3 = formattedPrint 0 format:"0.4f"
        format "\t% % % %\n" (i-1) f1 f2 f3	to:out_file
    )
    format "EndMove _base\n" to:out_file

    for i = 1 to out_mc.count do (
        case out_mc[i].typ of (
            0:(
                f1 = formattedPrint out_mc[i].trf[1][4].x format:"0.4f"
                f2 = formattedPrint out_mc[i].trf[1][4].y format:"0.4f"
                f3 = formattedPrint out_mc[i].trf[1][4].z format:"0.4f"
                format "\nBeginFrame % % % % % %\n" i f1 f2 f3 1 0	to:out_file
                for j = 1 to out_mc[i].trf.count do (
                    f1x = formattedPrint out_mc[i].trf[j][1].x format:"0.4f"
                    f1y = formattedPrint out_mc[i].trf[j][1].y format:"0.4f"
                    f1z = formattedPrint out_mc[i].trf[j][1].z format:"0.4f"
                    f2x = formattedPrint out_mc[i].trf[j][2].x format:"0.4f"
                    f2y = formattedPrint out_mc[i].trf[j][2].y format:"0.4f"
                    f2z = formattedPrint out_mc[i].trf[j][2].z format:"0.4f"
                    f3x = formattedPrint out_mc[i].trf[j][3].x format:"0.4f"
                    f3y = formattedPrint out_mc[i].trf[j][3].y format:"0.4f"
                    f3z = formattedPrint out_mc[i].trf[j][3].z format:"0.4f"
                    f4x = formattedPrint out_mc[i].trf[j][4].x format:"0.4f"
                    f4y = formattedPrint out_mc[i].trf[j][4].y format:"0.4f"
                    f4z = formattedPrint out_mc[i].trf[j][4].z format:"0.4f"
                    format "\t%    % % % % % % % % % % % %\n" (j-1) f1x f1y f1z f2x f2y f2z f3x f3y f3z f4x f4y f4z	to:out_file
                )
                format "EndFrame %\n" i	to:out_file
            )
            1:(
                format "\nBeginMorphData % %\n" i out_mc[i].def.count	to:out_file
                format "\n FrameWeight %\n" out_mc[i].def.count	to:out_file
                sum = 0
                for j = 1 to out_mc[i].def.count do (
                    sum = sum+1
                    case sum of (
                        1:(
                            if j == out_mc[i].def.count then (
                                format "  %\n" (j-1) to:out_file
                            )else(
                                format "  %" (j-1) to:out_file
                            )
                        )
                        8:(
                            format " %\n" (j-1)	to:out_file
                            sum = 0
                        )
                        default:(
                            if j == out_mc[i].def.count then (
                                format " %\n" (j-1)	to:out_file
                            )else(
                                format " %" (j-1) to:out_file
                            )
                        )
                    )
                )
                format "\n Vertices % T\n" out_mc[i].ver.count	to:out_file
                for j = 1 to out_mc[i].def.count do (
                    format "\n  Frame %\n" j	to:out_file
                    for k = 1 to out_mc[i].ver.count do (
                        f1 = formattedPrint out_mc[i].def[j][k].vert.x format:"0.4f"
                        f2 = formattedPrint out_mc[i].def[j][k].vert.y format:"0.4f"
                        f3 = formattedPrint out_mc[i].def[j][k].vert.z format:"0.4f"
                        f4 = formattedPrint out_mc[i].def[j][k].uv.x format:"0.4f"
                        f5 = formattedPrint out_mc[i].def[j][k].uv.y format:"0.4f" 
                        format "   % % % % %\n" f1 f2 f3 f4 f5	to:out_file
                    )
                )
                format "\nEndMorphData %\n" i	to:out_file
            )
            default:(body)
        )
    )
	close out_file
    /*结束导出*/
    return 1
)




rollout PrintRollout "流星MC菜单导出 0.5" width:730 height:348
(

    button CleBtn "清空" pos:[588,302] width:124 height:32
    button OutBtn "导出" pos:[444,302] width:124 height:32
    button InBtn_1 "顶点变形对象" pos:[300,302] width:124 height:32
    button InBtn_2 "放大缩小对象" pos:[156,302] width:124 height:32

    Edittext text1 "动画帧数：" text:"1" pos:[24,42] width:164 height:16
    Edittext text2 "这帧开始：" text:"0" pos:[24,62] width:164 height:16

    Edittext text3_1 "加载动画范围：" text:"" pos:[24,92] width:124 height:16
    Edittext text3_2 "到" text:"" pos:[154,92] width:54 height:16

    Edittext text4_1 "循环动画范围：" text:"" pos:[24,112] width:124 height:16
    Edittext text4_2 "到" text:"" pos:[154,112] width:54 height:16

    Edittext text5_1 "点击动画范围：" text:"" pos:[24,132] width:124 height:16
    Edittext text5_2 "到" text:"" pos:[154,132] width:54 height:16

    Edittext text6_1 "活动动画范围：" text:"" pos:[24,152] width:124 height:16
    Edittext text6_2 "到" text:"" pos:[154,152] width:54 height:16
        
    --label titleLabel1 "请设置导出的参数" pos:[12,12] width:150 height:16
    label titleLabel2 "菜单导出动画的总帧数" pos:[200,42] width:240 height:16
    label titleLabel3 "导出菜单动画的开始帧" pos:[200,62] width:320 height:16
    label titleLabel4 "菜单加载时播放的动画范围、不可为空、范围可为1" pos:[220,92] width:420 height:16
    label titleLabel5 "菜单加载完成后循环播放的动画范围、可为空、范围可为1、不可超出动画范围" pos:[220,112] width:420 height:16
    label titleLabel6 "菜单被点击后播放的动画范围、可为空、范围需要大于2" pos:[220,132] width:420 height:16
    label titleLabel7 "鼠标移动到菜单上时播放的动画范围、可为空、范围可为1" pos:[220,152] width:420 height:16
    label titleLabel8 "注：1、z轴需要为-390左右才能被点击，原按钮为-427\n    2、当某一范围为空时，如果后面有范围，将会变成该范围的功能！\n    3、mc动画帧是从0开始，0-0是1帧，0-1是2帧！\n    4、材质只支持bmp图片，图片需要放在texture文件夹中\n    5、材质混合属性在半透明(Opacity)后面、0：反向、1：过滤黑色、2：正常、3：过滤黑色\n    6、如果贴图要使用过滤颜色功能需要将贴图命名为：KMU00XX\n    7、如果要使用uv偏移，请给部件添加“UVW 变换”修改器，只支持UV的平铺和偏移！" pos:[24,176] width:720 height:96

    GroupBox grp1 "" pos:[6,10] width:718 height:268
    HyperLink add0 "To Lxres.com" pos:[8,328] width:124 height:16 address:"www.lxres.com" color:(color 94 234 255) hovercolor:(color 255 0 0)

    on InBtn_1 pressed do --选择变形部件
    (
        out_btn=selectByName title:"选择要导出的对象" ButtonText:"选择" filter:obj_filt /*只显示可编辑网格的模型*/
        if out_btn != undefined then
        (   
            for i = 1 to out_btn.count do (
                tmp = LX_OUT()
                tmp.obj = out_btn[i]
                tmp.typ = 1
                append out tmp
            )
        )
    )
    on InBtn_2 pressed do --选择平面部件
    (
        out_btn=selectByName title:"选择要导出的对象" ButtonText:"选择" filter:obj_filt /*只显示可编辑网格的模型*/
        if out_btn != undefined then
        (
            for i = 1 to out_btn.count do (
                tmp = LX_OUT()
                tmp.obj = out_btn[i]
                tmp.typ = 0
                tmp.fuv = 0
                append out tmp
            )
        )
    )
    on OutBtn pressed do --导出
    (   
        int1 = text1.text as Integer
        int2 = text2.text as Integer
        str1_1 = text3_1.text as string
        str1_2 = text3_2.text as string
        str2_1 = text4_1.text as string
        str2_2 = text4_2.text as string
        str3_1 = text5_1.text as string
        str3_2 = text5_2.text as string
        str4_1 = text6_1.text as string
        str4_2 = text6_2.text as string
        
        if str1_1 != "" and str1_2 != "" then(
            str1 = str1_1 + " " + str1_2
        )else(
            str1 = ""
        )
        if str2_1 != "" and str2_2 != "" then(
            str2 = str2_1 + " " + str2_2
        )else(
            str2 = ""
        )
        if str3_1 != "" and str3_2 != "" then(
            str3 = str3_1 + " " + str3_2
        )else(
            str3 = ""
        )
        if str4_1 != "" and str4_2 != "" then(
            str4 = str4_1 + " " + str4_2
        )else(
            str4 = ""
        )

        if out == undefined then
        (
            MessageBox("请先选择导出部件!") title:"错误!" beep:false
        )else if out.count == 0 then
        (
            MessageBox("请先选择导出部件!") title:"错误!" beep:false
        )else if int1 == undefined then
        (
            MessageBox("导出帧数只能是数字!") title:"错误!" beep:false
        )else if int1 < 1 then
        (
            MessageBox("请先设置导出帧数!") title:"错误!" beep:false
        )else if int2 == undefined then
        (
            MessageBox("导出的开始帧只能是数字!") title:"错误!" beep:false
        )else if int2 < 0 then
        (
            MessageBox("请先设置导出的开始帧!") title:"错误!" beep:false
        )else
        (
            out_name = getSaveFileName types:"流星MC菜单文件 (*.mc)|*.mc|All (*.*)|*.*|" caption:"导出MC菜单文件"
            if out_name != undefine then
            (
                case (exportLx out_name int1 int2 str1 str2 str3 str4) of (
                    1:(
                        MessageBox("导出完成!") title:"提示!" beep:false
                        --format "导出完成%\n" 	out_mc[1].tex
                    )
                    default:(
                        MessageBox("导出错误!") title:"提示!" beep:false
                    )
                )
            )  
        )
    )	
    on CleBtn pressed do
    (   
        if ((queryBox "是否清空选择的对象！") !=false )then (
            out=#() --导出部件寄存
            --out_mc=#() --寄存数据
        )
        --DestroyDialog PrintRollout
    )
)
CreateDialog PrintRollout

